/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.momosoftworks.coldsweat.api.event.vanilla.RenderHeartEvent;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ForgeIngameGui.class})
public abstract class MixinHeartRender {
    private static int HEART_INDEX = 0;
    private static boolean IS_CONTAINER = false;

    @Inject(method={"renderHealth"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/client/gui/ForgeIngameGui;blit(Lcom/mojang/blaze3d/matrix/MatrixStack;IIIIII)V", shift=At.Shift.AFTER)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;ceil(F)I", ordinal=3), to=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;disableBlend()V"))}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true, remap=false)
    private void renderHeart(int width, int height, MatrixStack ps, CallbackInfo ci, PlayerEntity player, int health, boolean blink, int healthLast, ModifiableAttributeInstance attrMaxHealth, float healthMax, float absorb, int healthRows, int rowHeight, int left, int top, int regen, int v, int BACKGROUND, int u, float absorbRemaining, int i, int row, int x, int y) {
        boolean halfHeart;
        int hearts = CSMath.ceil((double)health / 2.0);
        int lastHeartIndex = (int)(healthMax / 2.0f - (float)hearts);
        boolean bl = halfHeart = HEART_INDEX == lastHeartIndex + 1 && health % 2 == 1;
        RenderHeartEvent.HeartType heartType = IS_CONTAINER ? RenderHeartEvent.HeartType.CONTAINER : (absorbRemaining > 0.0f ? RenderHeartEvent.HeartType.ABSORBING : (player.func_70644_a(Effects.field_76436_u) ? RenderHeartEvent.HeartType.POISONED : (player.func_70644_a(Effects.field_82731_v) ? RenderHeartEvent.HeartType.WITHERED : RenderHeartEvent.HeartType.NORMAL)));
        MinecraftForge.EVENT_BUS.post((Event)new RenderHeartEvent(ps, heartType, x, y, blink, halfHeart));
        IS_CONTAINER = false;
    }

    @Inject(method={"renderHealth"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;ceil(F)I", ordinal=4)}, remap=false)
    private void incrementHeartIndex(int width, int height, MatrixStack mStack, CallbackInfo ci) {
        ++HEART_INDEX;
        IS_CONTAINER = true;
    }

    @Inject(method={"renderHealth"}, at={@At(value="HEAD")}, remap=false)
    private void resetHeartIndex(int width, int height, MatrixStack mStack, CallbackInfo ci) {
        HEART_INDEX = 0;
    }
}

