/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.TempEffectInit;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.FoodStats;
import net.minecraft.world.GameRules;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FoodStats.class})
public class MixinLimitFoodRegen {
    private static PlayerEntity STORED_PLAYER;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void storePlayer(PlayerEntity player, CallbackInfo ci) {
        STORED_PLAYER = player;
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/GameRules;getBoolean(Lnet/minecraft/world/GameRules$RuleKey;)Z"))
    private boolean limitRegenIfFreezing(GameRules gameRules, GameRules.RuleKey<GameRules.BooleanValue> key) {
        Map tempEffects;
        TempEffect freezeHealingEffect;
        if (key == GameRules.field_223606_i && (freezeHealingEffect = (TempEffect)(tempEffects = (Map)EntityTempManager.getTemperatureCap((Entity)STORED_PLAYER).map(ITemperatureCap::getTempEffects).orElse(new HashMap())).get(TempEffectInit.FREEZE_HEALING.get())) != null) {
            double effect = freezeHealingEffect.getEffectFactor();
            double heartsFreezePercentage = ConfigSettings.HEARTS_FREEZING_PERCENTAGE.get();
            if (heartsFreezePercentage != 0.0) {
                float maxHealth = STORED_PLAYER.func_110138_aP();
                float maxFrozenHealth = (float)((double)maxHealth * heartsFreezePercentage);
                float frozenHealth = Math.round(CSMath.blend(0.0, (double)maxFrozenHealth, effect, 0.0, 1.0));
                float unfrozenHealth = maxHealth - frozenHealth;
                if (STORED_PLAYER.func_110143_aJ() >= unfrozenHealth) {
                    return false;
                }
            }
        }
        return gameRules.func_223586_b(key);
    }
}

