/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import com.mojang.datafixers.util.Either;
import com.momosoftworks.coldsweat.data.ModRegistries;
import com.momosoftworks.coldsweat.data.RegistryHolder;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;

public class RegistryHelper {
    private static DynamicRegistries REGISTRY_ACCESS = null;

    @Nullable
    public static <T> Registry<T> getRegistry(RegistryKey<Registry<T>> registry) {
        return CSMath.getIfNotNull(RegistryHelper.getDynamicRegistries(), access -> access.func_243612_b(registry), null);
    }

    @Nullable
    public static DynamicRegistries getDynamicRegistries() {
        return REGISTRY_ACCESS;
    }

    public static <T> List<T> mapTaggableList(NegatableList<Either<ITag<T>, T>> eitherList) {
        ArrayList list = new ArrayList();
        for (Either<ITag<T>, T> either : eitherList.requirements()) {
            either.ifLeft(tag -> {
                if (tag != null) {
                    list.addAll(tag.func_230236_b_());
                }
            });
            either.ifRight(list::add);
        }
        for (Either<ITag<T>, T> either : eitherList.exclusions()) {
            either.ifLeft(tag -> {
                if (tag != null) {
                    list.removeAll(tag.func_230236_b_());
                }
            });
            either.ifRight(list::remove);
        }
        return list;
    }

    public static <T> List<T> mapTaggableList(List<Either<ITag<T>, T>> eitherList) {
        return RegistryHelper.mapTaggableList(new NegatableList<Either<ITag<T>, T>>(eitherList));
    }

    public static ResourceLocation getKey(ConfigData object) {
        for (RegistryHolder<?> registry : ModRegistries.getRegistries().values()) {
            if (!registry.type().isInstance(object)) continue;
            for (Map.Entry<ResourceLocation, ?> entry : registry.data().entrySet()) {
                if (entry.getValue() != object) continue;
                return entry.getKey();
            }
        }
        return new ResourceLocation("unknown");
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class GetAccessClient {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onClientLoading(ClientPlayerNetworkEvent.LoggedInEvent event) {
            if (!Minecraft.func_71410_x().func_71356_B()) {
                REGISTRY_ACCESS = event.getPlayer().field_71174_a.func_239165_n_();
            }
        }
    }

    @Mod.EventBusSubscriber
    public static class GetAccessServer {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onServerLoading(FMLServerAboutToStartEvent event) {
            REGISTRY_ACCESS = event.getServer().func_244267_aX();
        }
    }
}

