package com.momosoftworks.coldsweat.data.tag;

import com.momosoftworks.coldsweat.ColdSweat;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;

public class ModBlockTags
{
    public static final TagKey<Block> SOUL_STALK_PLACEABLE_ON = createTag("may_place_on/soul_stalk");
    public static final TagKey<Block> SOUL_SAND_REPLACEABLE = createTag("soul_sand_replaceable");

    public static final TagKey<Block> HEARTH_SPREAD_WHITELIST = createTag("hearth/spread_whitelist");
    public static final TagKey<Block> HEARTH_SPREAD_BLACKLIST = createTag("hearth/spread_blacklist");

    public static final TagKey<Block> IGNORE_SLEEP_CHECK = createTag("ignore_sleep_check");
    public static final TagKey<Block> CONNECTS_SMOKESTACK = createTag("connects_smokestack");
    public static final TagKey<Block> THERMAL_SOURCE = createTag("thermal_source");

    public static final TagKey<Block> SOUL_FIRE = createCommonTag("soul_fire");

    private static TagKey<Block> createTag(String name)
    {   return BlockTags.create(ResourceLocation.fromNamespaceAndPath(ColdSweat.MOD_ID, name));
    }

    private static TagKey<Block> createCommonTag(String name)
    {   return BlockTags.create(ResourceLocation.fromNamespaceAndPath("c", name));
    }
}
