/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.event.core.registry;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.momosoftworks.coldsweat.data.RegistryHolder;
import com.momosoftworks.coldsweat.data.codec.configuration.RegistryModifierData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import java.util.Collection;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.eventbus.api.Event;

public abstract class LoadRegistriesEvent
extends Event {
    DynamicRegistries registryAccess;
    Multimap<RegistryHolder<?>, ? extends ConfigData> registries;

    public LoadRegistriesEvent(DynamicRegistries registryAccess, Multimap<RegistryHolder<?>, ? extends ConfigData> registries) {
        this.registryAccess = registryAccess;
        this.registries = registries;
    }

    public DynamicRegistries getRegistryAccess() {
        return this.registryAccess;
    }

    public Multimap<RegistryHolder<?>, ? extends ConfigData> getRegistries() {
        return this.registries;
    }

    public <T extends ConfigData> Collection<T> getRegistry(RegistryHolder<T> registry) {
        return this.registries.get(registry);
    }

    public <T extends ConfigData> void addRegistryEntry(RegistryHolder<T> registry, T value) {
        this.registries.put(registry, value);
    }

    public <T extends ConfigData> void addRegistryEntries(RegistryHolder<T> registry, Collection<T> values) {
        this.registries.putAll(registry, values);
    }

    public static class Post
    extends LoadRegistriesEvent {
        public Post(DynamicRegistries registryAccess, Multimap<RegistryHolder<?>, ? extends ConfigData> registries) {
            super(registryAccess, registries);
        }
    }

    public static class Pre
    extends LoadRegistriesEvent {
        private Multimap<RegistryKey<Registry<? extends ConfigData>>, RegistryModifierData<?>> modifiers;

        public Pre(DynamicRegistries registryAccess, Multimap<RegistryHolder<?>, ? extends ConfigData> registries, Multimap<RegistryHolder<?>, RegistryModifierData<?>> modifiers) {
            super(registryAccess, registries);
        }

        public Multimap<RegistryKey<Registry<? extends ConfigData>>, RegistryModifierData<?>> getRegistryModifiers() {
            return ImmutableMultimap.copyOf(this.modifiers);
        }
    }
}

