/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.function.Function;
import net.minecraft.entity.LivingEntity;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public class ShadeTempModifier
extends TempModifier {
    @Override
    protected Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        World level = entity.field_70170_p;
        if (level.func_230315_m_().func_236037_d_() || !level.func_230315_m_().func_218272_d()) {
            return temp -> temp;
        }
        double darkness = 1.0 - (double)level.func_226658_a_(LightType.SKY, entity.func_233580_cy_()) / 15.0;
        double overcast = level.func_72867_j(1.0f);
        double shade = Math.max(darkness *= Math.max(0.0, WorldHelper.getTimeMultiplier((IWorld)level)), overcast);
        double shadeAmount = CSMath.blend(0.0, ConfigSettings.SHADE_TEMP_OFFSET.get(), shade, 0.0, 1.0);
        return temp -> temp + shadeAmount;
    }
}

