/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;

public class CyclingSlotBackground {
    private static final int ICON_CHANGE_TICK_RATE = 30;
    private static final int ICON_SIZE = 16;
    private static final int ICON_TRANSITION_TICK_DURATION = 4;
    private final int slotIndex;
    private final List<ResourceLocation> icons;
    private int tick;
    private int iconIndex;

    public CyclingSlotBackground(int slotIndex, List<ResourceLocation> icons) {
        this.slotIndex = slotIndex;
        this.icons = icons;
    }

    public void tick() {
        if (!this.icons.isEmpty() && ++this.tick % 30 == 0) {
            this.iconIndex = (this.iconIndex + 1) % this.icons.size();
        }
    }

    public void render(Container menu, MatrixStack poseStack, float partialTick, int guiLeft, int guiTop) {
        Slot slot = menu.func_75139_a(this.slotIndex);
        if (!this.icons.isEmpty() && !slot.func_75216_d()) {
            float transparency;
            boolean shouldTransition = this.icons.size() > 1 && this.tick >= 30;
            float f = transparency = shouldTransition ? this.getIconTransitionTransparency(partialTick) : 1.0f;
            if (transparency < 1.0f) {
                int iconIndex = Math.floorMod(this.iconIndex - 1, this.icons.size());
                this.renderIcon(slot, this.icons.get(iconIndex), 1.0f - transparency, poseStack, guiLeft, guiTop);
            }
            this.renderIcon(slot, this.icons.get(this.iconIndex), transparency, poseStack, guiLeft, guiTop);
        }
    }

    private void renderIcon(Slot slot, ResourceLocation icon, float alpha, MatrixStack poseStack, int x, int y) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(icon);
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        Screen.func_238463_a_((MatrixStack)poseStack, (int)(x + slot.field_75223_e), (int)(y + slot.field_75221_f), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private float getIconTransitionTransparency(float partialTick) {
        float $$1 = (float)(this.tick % 30) + partialTick;
        return Math.min($$1, 4.0f) / 4.0f;
    }
}

