/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.blockentity;

import com.momosoftworks.coldsweat.common.block.IceboxBlock;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.container.IceboxContainer;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.BlockEntityInit;
import com.momosoftworks.coldsweat.core.init.ParticleTypesInit;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.registries.ModSounds;
import com.momosoftworks.coldsweat.util.render.ChestLidController;
import com.momosoftworks.coldsweat.util.render.ContainerOpenersCounter;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

@OnlyIn(value=Dist.CLIENT, _interface=IChestLid.class)
public class IceboxBlockEntity
extends HearthBlockEntity
implements ITickableTileEntity,
ISidedInventory,
IChestLid {
    public static int[] WATERSKIN_SLOTS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    public static int[] FUEL_SLOT = new int[]{0};
    private boolean hasItemStacks = false;
    LazyOptional<? extends IItemHandler>[] slotHandlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        @Override
        protected void onOpen(World level, BlockPos pos, BlockState state) {
            if (!IceboxBlockEntity.this.hasSmokestack()) {
                IceboxBlockEntity.this.field_145850_b.func_184133_a(null, pos, ModSounds.ICEBOX_OPEN, SoundCategory.BLOCKS, 1.0f, level.field_73012_v.nextFloat() * 0.2f + 0.9f);
            }
        }

        @Override
        protected void onClose(World level, BlockPos pos, BlockState state) {
            if (!IceboxBlockEntity.this.hasSmokestack()) {
                IceboxBlockEntity.this.field_145850_b.func_184133_a(null, pos, ModSounds.ICEBOX_CLOSE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }

        @Override
        protected void openerCountChanged(World level, BlockPos pos, BlockState state, int eventId, int eventParam) {
            IceboxBlockEntity.this.signalOpenCount(level, pos, state, eventId, eventParam);
        }

        @Override
        protected boolean isOwnContainer(PlayerEntity player) {
            return player.field_71070_bA instanceof IceboxContainer && ((Object)((Object)((IceboxContainer)player.field_71070_bA).te)).equals((Object)IceboxBlockEntity.this);
        }
    };
    ChestLidController lidController = new ChestLidController();

    public IceboxBlockEntity() {
        super((TileEntityType<? extends HearthBlockEntity>)((TileEntityType)BlockEntityInit.ICEBOX_BLOCK_ENTITY_TYPE.get()));
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(null, pkt.func_148857_g());
    }

    @Override
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.lidController.shouldBeOpen(type > 0);
            return true;
        }
        return super.func_145842_c(id, type);
    }

    protected void signalOpenCount(World level, BlockPos pos, BlockState state, int eventId, int eventParam) {
        Block block = state.func_177230_c();
        level.func_175641_c(pos, block, eventId, eventParam);
    }

    @Override
    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.cold_sweat.icebox");
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.func_201670_d()) {
            this.lidController.tickLid();
        }
        BlockState state = this.func_195044_w();
        if (!this.field_145846_f && this.field_145850_b != null && this.field_145850_b.func_73046_m() != null) {
            this.openersCounter.recheckOpeners(this.field_145850_b, this.func_174877_v(), this.func_195044_w());
        }
        if (!this.field_145850_b.func_201670_d() && this.getFuel() > 0 && this.ticksExisted % (int)(20.0 / Math.max(1.0, ConfigSettings.TEMP_RATE.get())) == 0) {
            this.hasItemStacks = false;
            for (int i = 1; i < 10; ++i) {
                ItemStack stack = this.func_70301_a(i);
                CompoundNBT tag = NBTHelper.getTagOrEmpty(stack);
                double itemTemp = tag.func_74769_h("Temperature");
                if (stack.func_77973_b() != ModItems.FILLED_WATERSKIN || !(itemTemp > -50.0)) continue;
                this.hasItemStacks = true;
                tag.func_74780_a("Temperature", Math.max(-50.0, itemTemp - 1.0));
            }
        }
    }

    @Override
    public int getSpreadRange() {
        return ConfigSettings.ICEBOX_RANGE.get();
    }

    @Override
    public int getMaxRange() {
        return ConfigSettings.ICEBOX_MAX_RANGE.get();
    }

    @Override
    public int getMaxPaths() {
        return ConfigSettings.ICEBOX_MAX_VOLUME.get();
    }

    @Override
    public int getInsulationTime() {
        return ConfigSettings.ICEBOX_WARM_UP_TIME.get();
    }

    @Override
    public int getMaxInsulationLevel() {
        return ConfigSettings.ICEBOX_MAX_INSULATION.get();
    }

    @Override
    public SoundEvent getFuelDepleteSound() {
        return ModSounds.ICEBOX_DEPLETE;
    }

    @Override
    public boolean hasSmokestack() {
        return this.hasSmokestack;
    }

    @Override
    protected boolean isSmartEnabled() {
        return ConfigSettings.SMART_ICEBOX.get();
    }

    @Override
    protected void tickPaths(int firstIndex, int lastIndex) {
        if (this.hasSmokestack) {
            super.tickPaths(firstIndex, lastIndex);
        }
    }

    @Override
    protected int getFuelDrainInterval() {
        return ConfigSettings.ICEBOX_FUEL_INTERVAL.get();
    }

    @Override
    public boolean isUsingColdFuel() {
        return super.isUsingColdFuel() || this.hasItemStacks;
    }

    @Override
    public void checkForStateChange() {
        super.checkForStateChange();
        this.ensureState(IceboxBlock.FROSTED, this.getColdFuel() > 0);
    }

    @Override
    public List<Direction> getCoolingSides() {
        return Arrays.asList(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN);
    }

    @Override
    public List<Direction> getHeatingSides() {
        return Arrays.asList(new Direction[0]);
    }

    @Override
    public int getItemFuel(ItemStack item) {
        return CSMath.getIfNotNull(ConfigHelper.getFirstOrNull(ConfigSettings.ICEBOX_FUEL, item.func_77973_b(), data -> data.test(item)), FuelData::fuel, 0.0).intValue();
    }

    @Override
    protected void storeFuel(ItemStack stack, int amount) {
        if ((double)this.getFuel() < (double)this.getMaxFuel() - (double)Math.abs(amount) * 0.75) {
            if (!stack.hasContainerItem() || stack.func_190916_E() > 1) {
                int consumeCount = Math.min((int)Math.floor((double)(this.getMaxFuel() - this.getFuel()) / (double)Math.abs(amount)), stack.func_190916_E());
                stack.func_190918_g(consumeCount);
                this.addFuel(amount * consumeCount);
            } else {
                this.func_70299_a(0, stack.getContainerItem());
                this.addFuel(amount);
            }
        }
    }

    public int getFuel() {
        return this.getColdFuel();
    }

    public void setFuel(int amount) {
        this.setColdFuel(amount, true);
    }

    @Override
    public void addFuel(int amount) {
        this.setColdFuel(this.getColdFuel() + amount);
    }

    @Override
    protected boolean isFuelChanged() {
        return this.ticksExisted % 10 == 0;
    }

    @Override
    protected Container func_213906_a(int id, PlayerInventory playerInv) {
        return new IceboxContainer(id, playerInv, this);
    }

    public void func_174889_b(PlayerEntity player) {
        super.func_174889_b(player);
        this.openersCounter.incrementOpeners(player, this.field_145850_b, this.func_174877_v(), this.func_195044_w());
    }

    public void func_174886_c(PlayerEntity player) {
        super.func_174886_c(player);
        this.openersCounter.decrementOpeners(player, this.field_145850_b, this.func_174877_v(), this.func_195044_w());
    }

    @Override
    protected void tickParticles() {
        if (this.hasSmokestack) {
            super.tickParticles();
        }
    }

    @Override
    public BasicParticleType getAirParticle() {
        return (BasicParticleType)ParticleTypesInit.GROUND_MIST.get();
    }

    @Override
    public void spawnAirParticle(int x, int y, int z, Random rand) {
        BlockPos pos = new BlockPos(x, y, z);
        boolean onGround = !this.field_145850_b.func_180495_p(pos.func_177977_b()).func_196958_f();
        float f = rand.nextFloat();
        float f2 = this.spreading ? 0.016f : 0.032f;
        if (f > f2) {
            return;
        }
        float xr = rand.nextFloat();
        float yr = onGround ? 0.1f : rand.nextFloat();
        float zr = rand.nextFloat();
        float xm = rand.nextFloat() / 20.0f - 0.025f;
        float zm = rand.nextFloat() / 20.0f - 0.025f;
        this.field_145850_b.func_195590_a(onGround ? (IParticleData)ParticleTypesInit.GROUND_MIST.get() : (IParticleData)ParticleTypesInit.MIST.get(), false, (double)((float)x + xr), (double)((float)y + yr), (double)((float)z + zr), (double)xm, 0.0, (double)zm);
    }

    @Override
    public int func_70302_i_() {
        return 10;
    }

    @Override
    public int[] func_180463_a(Direction side) {
        return side.func_176740_k() == Direction.Axis.Y ? WATERSKIN_SLOTS : FUEL_SLOT;
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, Direction direction) {
        if (slot == 0) {
            return this.getItemFuel(stack) != 0;
        }
        return ModItemTags.ICEBOX_VALID.func_230235_a_((Object)stack.func_77973_b()) || stack.func_222117_E();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction face) {
        if (!this.field_145846_f && face != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (face == Direction.UP) {
                return this.slotHandlers[0].cast();
            }
            if (face == Direction.DOWN) {
                return this.slotHandlers[1].cast();
            }
            return this.slotHandlers[2].cast();
        }
        return super.getCapability(capability, face);
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, Direction direction) {
        return slot > 0;
    }

    public float func_195480_a(float partialTick) {
        return this.lidController.getOpenness(partialTick);
    }
}

