/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.entity.data;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.EnumHelper;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import com.momosoftworks.coldsweat.util.serialization.StringRepresentable;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public enum Preference {
    UNITS("Units", PacketBuffer::func_179249_a, buf -> (Temperature.Units)buf.func_179257_a(Temperature.Units.class), () -> ConfigSettings.CELSIUS.get() != false ? Temperature.Units.C : Temperature.Units.F),
    WATERSKIN_PRIMARY("WaterskinPrimary", PacketBuffer::func_179249_a, buf -> (WaterskinAction)buf.func_179257_a(WaterskinAction.class), ConfigSettings.WATERSKIN_USE_PRIMARY),
    WATERSKIN_SECONDARY("WaterskinSecondary", PacketBuffer::func_179249_a, buf -> (WaterskinAction)buf.func_179257_a(WaterskinAction.class), ConfigSettings.WATERSKIN_USE_SECONDARY);

    private final String key;
    private final Writer<?> writer;
    private final Reader<?> reader;
    private final Supplier<?> getter;

    private <T> Preference(String key, Writer<T> writer, Reader<T> reader, Supplier<T> getter) {
        this.key = key;
        this.writer = writer;
        this.reader = reader;
        this.getter = getter;
    }

    public String key() {
        return this.key;
    }

    public Writer writer() {
        return this.writer;
    }

    public Reader reader() {
        return this.reader;
    }

    public Supplier getter() {
        return this.getter;
    }

    @Nullable
    public static <T> T get(PlayerEntity player, Preference preference) {
        CompoundNBT preferenceNBT = player.getPersistentData().func_74775_l("ColdSweatPreferences");
        if (!preferenceNBT.func_74764_b(preference.key())) {
            return null;
        }
        return (T)NBTHelper.deserialize(preferenceNBT.func_74781_a(preference.key()));
    }

    public static <T> T getOrDefault(PlayerEntity player, Preference preference, T defaultValue) {
        return (T)CSMath.orElse(Preference.get(player, preference), defaultValue);
    }

    public static enum WaterskinAction implements StringRepresentable
    {
        DRINK("drink"),
        POUR("pour"),
        NONE("none");

        private final String name;

        private WaterskinAction(String name) {
            this.name = name;
        }

        @Override
        public String func_176610_l() {
            return this.name;
        }

        public static WaterskinAction byName(String name) {
            return (WaterskinAction)EnumHelper.byName((Enum[])WaterskinAction.values(), (String)name);
        }
    }

    @FunctionalInterface
    public static interface Reader<T>
    extends Function<PacketBuffer, T> {
    }

    @FunctionalInterface
    public static interface Writer<T>
    extends BiConsumer<PacketBuffer, T> {
    }
}

