/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.entity.data.edible;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.common.entity.data.edible.BiomeSearchingEdible;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.world.IWorld;

public class HotBiomeEdible
extends BiomeSearchingEdible {
    public HotBiomeEdible() {
        super((level, biome) -> {
            Pair<Double, Double> minMaxTemp = WorldHelper.getBiomeTemperatureRange((IWorld)level, biome);
            double biomeTemp = CSMath.averagePair(minMaxTemp);
            return biomeTemp >= 1.5;
        });
    }

    @Override
    public int getCooldown() {
        return (int)(Math.random() * 400.0 + 1200.0);
    }

    @Override
    public ITag.INamedTag<Item> associatedItems() {
        return ModItemTags.CHAMELEON_HOT;
    }

    @Override
    public String getName() {
        return "cold_sweat:hot_biomes";
    }
}

