/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.item;

import com.momosoftworks.coldsweat.api.temperature.modifier.WaterTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WaterskinTempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.event.TooltipHandler;
import com.momosoftworks.coldsweat.common.entity.data.Preference;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.core.init.ItemInit;
import com.momosoftworks.coldsweat.core.itemgroup.ColdSweatGroup;
import com.momosoftworks.coldsweat.core.network.message.ParticleBatchMessage;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.registries.ModSounds;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FilledWaterskinItem
extends Item {
    public static final double EFFECT_RATE = 0.5;
    public static final String NBT_TEMPERATURE = "Temperature";
    private static final IDispenseItemBehavior DISPENSE_BEHAVIOR = (source, stack) -> {
        final BlockPos pos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
        ServerWorld level = source.func_197524_h();
        IChunk chunk = WorldHelper.getChunk((IWorld)level, pos);
        double itemTemp = stack.func_196082_o().func_74769_h(NBT_TEMPERATURE);
        if (chunk == null) {
            return stack;
        }
        level.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_204327_f, SoundCategory.PLAYERS, 1.0f, (float)(Math.random() / 5.0 + 0.9), false);
        Random rand = new Random();
        for (int i = 0; i < 6; ++i) {
            TaskScheduler.scheduleServer(() -> FilledWaterskinItem.lambda$null$1(rand, pos, (World)level), i);
        }
        new Object((World)level, itemTemp, chunk){
            double acceleration = 0.0;
            int tick = 0;
            AxisAlignedBB aabb = new AxisAlignedBB(pos).func_186662_g(0.5);
            List affectedPlayers = new ArrayList();
            final /* synthetic */ World val$level;
            final /* synthetic */ double val$itemTemp;
            final /* synthetic */ IChunk val$chunk;
            {
                this.val$level = world;
                this.val$itemTemp = d;
                this.val$chunk = iChunk;
            }

            void start() {
                MinecraftForge.EVENT_BUS.register((Object)this);
            }

            @SubscribeEvent
            public void onTick(TickEvent.WorldTickEvent event) {
                if (event.world.field_72995_K == this.val$level.field_72995_K && event.phase == TickEvent.Phase.START) {
                    double waterTemp = CSMath.blend(this.val$itemTemp, this.val$itemTemp / 5.0, (double)this.tick, 20.0, 100.0);
                    double effectAmount = waterTemp * ((double)ConfigSettings.WATERSKIN_CONSUME_STRENGTH.get().intValue() / 50.0);
                    double wetnessTemp = 0.05 * (double)CSMath.sign(waterTemp + 0.01);
                    this.aabb = this.aabb.func_72317_d(0.0, -this.acceleration, 0.0);
                    BlockPos pos2 = new BlockPos(this.aabb.field_72340_a, this.aabb.field_72338_b, this.aabb.field_72339_c);
                    if (WorldHelper.isSpreadBlocked((IWorld)this.val$level, this.val$chunk.func_180495_p(pos2), pos2, Direction.DOWN, Direction.DOWN)) {
                        MinecraftForge.EVENT_BUS.unregister((Object)this);
                        return;
                    }
                    this.val$level.func_217357_a(PlayerEntity.class, this.aabb).forEach(player -> {
                        if (!this.affectedPlayers.contains(player)) {
                            Temperature.addModifier((LivingEntity)player, new WaterskinTempModifier(effectAmount).expires(0), Temperature.Trait.CORE, Placement.Duplicates.ALLOW);
                            Temperature.addOrReplaceModifier((LivingEntity)player, new WaterTempModifier(wetnessTemp).tickRate(5), Temperature.Trait.WORLD, Placement.Duplicates.BY_CLASS);
                            this.affectedPlayers.add(player);
                        }
                    });
                    this.acceleration += 0.0052;
                    ++this.tick;
                    if (this.tick > 100) {
                        MinecraftForge.EVENT_BUS.unregister((Object)this);
                    }
                }
            }
        }.start();
        return stack.getContainerItem();
    };

    public FilledWaterskinItem() {
        super(new Item.Properties().func_200916_a((ItemGroup)ColdSweatGroup.COLD_SWEAT).func_200917_a(1).func_200919_a((Item)ItemInit.WATERSKIN.get()));
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)DISPENSE_BEHAVIOR);
    }

    public static ItemStack getDisplayStack() {
        return new ItemStack((IItemProvider)ModItems.FILLED_WATERSKIN);
    }

    public int getMaxDamage(ItemStack stack) {
        return ConfigSettings.WATERSKIN_USES.get();
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 2973406;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77952_i() > 0;
    }

    private static int getDurability(ItemStack stack) {
        return Math.max(0, stack.func_77958_k() - stack.func_77952_i());
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int slot, boolean isSelected) {
        super.func_77663_a(itemstack, world, entity, slot, isSelected);
        if (entity.field_70173_aa % 5 == 0 && entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            double itemTemp = itemstack.func_196082_o().func_74769_h(NBT_TEMPERATURE);
            if (itemTemp != 0.0 && slot <= 8 || player.func_184592_cb().equals(itemstack)) {
                double drainAmt = 0.025 * ConfigSettings.WATERSKIN_NEUTRALIZE_SPEED.get();
                double newTemp = CSMath.shrink(itemTemp, drainAmt * 5.0);
                double tempEffect = 0.05 * ConfigSettings.WATERSKIN_HOTBAR_STRENGTH.get();
                itemstack.func_196082_o().func_74780_a(NBT_TEMPERATURE, newTemp);
                Temperature.addModifier((LivingEntity)player, new WaterskinTempModifier(tempEffect * (double)CSMath.sign(itemTemp)).expires(5), Temperature.Trait.CORE, Placement.Duplicates.ALLOW);
            }
        }
    }

    public static boolean performPourAction(ItemStack stack, LivingEntity entity, Hand hand) {
        if (!(entity instanceof PlayerEntity) || stack.func_77973_b() != ModItems.FILLED_WATERSKIN) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (!player.field_70170_p.field_72995_K) {
            double temperature = stack.func_196082_o().func_74769_h(NBT_TEMPERATURE);
            double effectAmount = temperature * ((double)ConfigSettings.WATERSKIN_CONSUME_STRENGTH.get().intValue() / 50.0);
            Temperature.addModifier((LivingEntity)player, new WaterskinTempModifier(effectAmount).expires(0), Temperature.Trait.CORE, Placement.Duplicates.ALLOW);
            double wetnessTemp = 0.05 * (double)CSMath.sign(temperature == 0.0 ? 1.0 : temperature);
            Temperature.addOrReplaceModifier((LivingEntity)player, new WaterTempModifier(wetnessTemp).tickRate(5), Temperature.Trait.WORLD, Placement.Duplicates.BY_CLASS);
            WorldHelper.playEntitySound(ModSounds.WATERSKIN_POUR, (Entity)player, player.func_184176_by(), 2.0f, (float)(Math.random() / 5.0 + 0.9));
        }
        FilledWaterskinItem.consumeWaterskin(stack, (LivingEntity)player, hand);
        player.func_226292_a_(hand, true);
        Random rand = new Random();
        for (int i = 0; i < 6; ++i) {
            TaskScheduler.scheduleServer(() -> {
                ParticleBatchMessage particleBatch = new ParticleBatchMessage(2);
                for (int p = 0; p < 10; ++p) {
                    AxisAlignedBB playerBB = player.func_213305_a(player.func_213283_Z()).func_242286_a(player.func_213303_ch()).func_186662_g(0.2);
                    particleBatch.addParticle((IParticleData)ParticleTypes.field_218425_n, MathHelper.func_219803_d((double)rand.nextFloat(), (double)playerBB.field_72340_a, (double)playerBB.field_72336_d), playerBB.field_72337_e, MathHelper.func_219803_d((double)rand.nextFloat(), (double)playerBB.field_72339_c, (double)playerBB.field_72334_f), 0.3, 0.3, 0.3);
                }
                particleBatch.sendEntity((Entity)player);
            }, i);
        }
        player.func_70066_B();
        player.func_184811_cZ().func_185145_a(ModItems.FILLED_WATERSKIN, 10);
        player.func_184811_cZ().func_185145_a(ModItems.WATERSKIN, 10);
        return true;
    }

    public static ItemStack consumeWaterskin(ItemStack stack, LivingEntity entity, Hand usedHand) {
        ItemStack emptyStack = stack.getContainerItem();
        if (entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71071_by.func_70431_c(emptyStack)) {
            PlayerEntity player = (PlayerEntity)entity;
            player.func_191521_c(emptyStack);
            player.func_184611_a(usedHand, ItemStack.field_190927_a);
            return ItemStack.field_190927_a;
        }
        entity.func_184611_a(usedHand, emptyStack);
        return emptyStack;
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        if (player.func_213453_ef()) {
            return FilledWaterskinItem.performAction(Preference.getOrDefault(player, Preference.WATERSKIN_SECONDARY, Preference.WaterskinAction.DRINK), level, player, hand);
        }
        return FilledWaterskinItem.performAction(Preference.getOrDefault(player, Preference.WATERSKIN_PRIMARY, Preference.WaterskinAction.POUR), level, player, hand);
    }

    public void func_219972_a(World level, LivingEntity entity, ItemStack stack, int remainingTicks) {
        super.func_219972_a(level, entity, stack, remainingTicks);
        if (remainingTicks % 5 == 0 && remainingTicks < this.func_77626_a(stack) - 5) {
            Vector3d playerPos = entity.func_213303_ch().func_72441_c(0.0, (double)(entity.func_213302_cg() / 2.0f), 0.0);
            Vector3d lookVec = new Vector3d(entity.func_70040_Z().field_72450_a, 0.0, entity.func_70040_Z().field_72449_c).func_72432_b();
            Vector3d particlePos = playerPos.func_178787_e(lookVec.func_186678_a(0.3));
            WorldHelper.spawnParticleBatch(level, (IParticleData)ParticleTypes.field_218422_X, particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, 0.2, 0.2, 0.2, 4.0, 0.0);
        }
    }

    private static ActionResult<ItemStack> performAction(Preference.WaterskinAction action, World level, PlayerEntity player, Hand hand) {
        switch (action) {
            case DRINK: {
                return DrinkHelper.func_234707_a_((World)level, (PlayerEntity)player, (Hand)hand);
            }
            case POUR: {
                if (!FilledWaterskinItem.performPourAction(player.func_184586_b(hand), (LivingEntity)player, hand)) break;
                return ActionResult.func_226249_b_((Object)player.func_184586_b(hand));
            }
        }
        return ActionResult.func_226250_c_((Object)player.func_184586_b(hand));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World level = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = level.func_180495_p(pos);
        PlayerEntity player = context.func_195999_j();
        if (state.func_203425_a(Blocks.field_150383_bp)) {
            int waterLevel = (Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a);
            if (waterLevel >= 3) {
                return ActionResultType.PASS;
            }
            state = (BlockState)state.func_206870_a((Property)CauldronBlock.field_176591_a, (Comparable)Integer.valueOf(waterLevel + 1));
            level.func_180501_a(pos, state, 3);
            if (!level.field_72995_K) {
                level.func_184133_a(null, pos, ModSounds.WATERSKIN_FILL, SoundCategory.BLOCKS, 2.0f, (float)Math.random() / 5.0f + 0.9f);
                WorldHelper.spawnParticleBatch(level, (IParticleData)ParticleTypes.field_218422_X, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.65, (double)pos.func_177952_p() + 0.5, 0.5, 0.5, 0.5, 10.0, 0.0);
            }
            if (player != null) {
                FilledWaterskinItem.consumeWaterskin(context.func_195996_i(), (LivingEntity)player, context.func_221531_n());
                player.func_184811_cZ().func_185145_a(ModItems.WATERSKIN, 10);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public ItemStack func_77654_b(ItemStack stack, World level, LivingEntity entity) {
        double amount = stack.func_196082_o().func_74769_h(NBT_TEMPERATURE) * ((double)ConfigSettings.WATERSKIN_CONSUME_STRENGTH.get().intValue() / 50.0);
        Temperature.addModifier(entity, new WaterskinTempModifier(amount / (double)(100 * stack.func_77958_k())).expires(100), Temperature.Trait.CORE, Placement.Duplicates.ALLOW);
        if (entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_()) {
            return stack;
        }
        if (FilledWaterskinItem.getDurability(stack) <= 1) {
            return FilledWaterskinItem.consumeWaterskin(stack, entity, entity.func_184600_cs());
        }
        stack.func_196085_b(stack.func_77952_i() + 1);
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World level, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        double temp = CSMath.round(stack.func_196082_o().func_74769_h(NBT_TEMPERATURE), 2);
        double multiplier = (double)ConfigSettings.WATERSKIN_CONSUME_STRENGTH.get().intValue() / 50.0;
        IFormattableTextComponent filledLabel = new TranslationTextComponent("item.cold_sweat.waterskin.filled").func_240699_a_(TextFormatting.GRAY);
        if (ConfigSettings.ENABLE_HINTS.get().booleanValue() && !TooltipHandler.isShiftDown()) {
            filledLabel.func_230529_a_((ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)TooltipHandler.EXPAND_TOOLTIP));
        }
        tooltip.add((ITextComponent)filledLabel);
        int useEffect = (int)Math.round(temp * multiplier);
        IFormattableTextComponent tempText = useEffect > 0 ? new TranslationTextComponent("tooltip.cold_sweat.temperature_effect", new Object[]{"+" + useEffect}).func_240703_c_(TooltipHandler.HOT) : (useEffect == 0 ? new TranslationTextComponent("tooltip.cold_sweat.temperature_effect", new Object[]{"+" + useEffect}).func_240699_a_(TextFormatting.WHITE) : new TranslationTextComponent("tooltip.cold_sweat.temperature_effect", new Object[]{useEffect}).func_240703_c_(TooltipHandler.COLD));
        tooltip.add((ITextComponent)new StringTextComponent(""));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.cold_sweat.used").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)tempText);
        if (TooltipHandler.isShiftDown()) {
            if (ConfigSettings.ENABLE_HINTS.get().booleanValue()) {
                String crouchAction;
                String crouchKey = Minecraft.func_71410_x().field_71474_y.field_228046_af_.getKey().func_237520_d_().getString();
                switch (Preference.getOrDefault((PlayerEntity)Minecraft.func_71410_x().field_71439_g, Preference.WATERSKIN_SECONDARY, Preference.WaterskinAction.POUR)) {
                    case DRINK: {
                        crouchAction = "tooltip.cold_sweat.waterskin.drink";
                        break;
                    }
                    case POUR: {
                        crouchAction = "tooltip.cold_sweat.waterskin.pour";
                        break;
                    }
                    default: {
                        crouchAction = "";
                    }
                }
                if (!crouchAction.isEmpty()) {
                    tooltip.add(2, (ITextComponent)new TranslationTextComponent(crouchAction, new Object[]{new StringTextComponent(crouchKey).func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.DARK_GRAY));
                }
            }
            String perSecond = new TranslationTextComponent("tooltip.cold_sweat.per_second").getString();
            tooltip.add((ITextComponent)new StringTextComponent(""));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.cold_sweat.hotbar").func_240699_a_(TextFormatting.GRAY));
            double effectRate = 0.5 * ConfigSettings.WATERSKIN_HOTBAR_STRENGTH.get();
            IFormattableTextComponent tempEffectText = (temp > 0.0 ? new TranslationTextComponent("tooltip.cold_sweat.temperature_effect", new Object[]{"+" + CSMath.round(effectRate, 2)}).func_240703_c_(TooltipHandler.HOT) : (temp == 0.0 ? new TranslationTextComponent("tooltip.cold_sweat.temperature_effect", new Object[]{"+0"}).func_240699_a_(TextFormatting.WHITE) : new TranslationTextComponent("tooltip.cold_sweat.temperature_effect", new Object[]{"-" + CSMath.round(effectRate, 2)}).func_240703_c_(TooltipHandler.COLD))).func_240702_b_(perSecond);
            tooltip.add((ITextComponent)tempEffectText);
        }
        super.func_77624_a(stack, level, tooltip, advanced);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (stack.func_77973_b() instanceof FilledWaterskinItem) {
            ItemStack emptyWaterskin = new ItemStack((IItemProvider)ModItems.WATERSKIN);
            emptyWaterskin.func_77982_d(stack.func_77978_p());
            emptyWaterskin.func_196083_e(NBT_TEMPERATURE);
            emptyWaterskin.func_196083_e("Damage");
            emptyWaterskin.func_196083_e("Purity");
            return emptyWaterskin;
        }
        return stack;
    }

    public String func_77658_a() {
        return new TranslationTextComponent("item.cold_sweat.waterskin").getString();
    }

    private static /* synthetic */ void lambda$null$1(Random rand, BlockPos pos, World level) {
        ParticleBatchMessage particles = new ParticleBatchMessage(2);
        for (int p = 0; p < rand.nextInt(5) + 5; ++p) {
            particles.addParticle((IParticleData)ParticleTypes.field_218425_n, new ParticleBatchMessage.ParticlePlacement((double)pos.func_177958_n() + rand.nextDouble(), (double)pos.func_177956_o() + rand.nextDouble(), (double)pos.func_177952_p() + rand.nextDouble(), 0.0, 0.0, 0.0));
        }
        particles.sendWorld(level);
    }
}

