/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.advancement.trigger;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.core.advancement.trigger.TriggerHelper;
import com.momosoftworks.coldsweat.mixin.MixinTriggerBounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.BlockPredicate;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class BlockAffectTempTrigger
extends AbstractCriterionTrigger<Instance> {
    static final ResourceLocation ID = new ResourceLocation("cold_sweat", "block_affects_temperature");

    protected Instance createInstance(JsonObject json, EntityPredicate.AndPredicate player, ConditionArrayParser context) {
        double distance = json.has("distance") ? json.get("distance").getAsDouble() : 0.0;
        double totalEffect = json.has("total_effect") ? json.get("total_effect").getAsDouble() : 0.0;
        BlockPredicate block = BlockPredicate.func_226237_a_((JsonElement)json.get("blocks"));
        ArrayList<TriggerHelper.TempCondition> conditions = new ArrayList<TriggerHelper.TempCondition>();
        if (json.has("temperature")) {
            JsonArray tempList = json.get("temperature").getAsJsonArray();
            for (JsonElement element : tempList) {
                JsonObject entry = element.getAsJsonObject();
                Temperature.Trait trait = Temperature.Trait.fromID(entry.get("type").getAsString());
                TriggerHelper.getTempValueOrRange(entry).ifLeft(either -> conditions.add(new TriggerHelper.TempCondition(trait, (double)either, (double)either))).ifRight(pair -> conditions.add(new TriggerHelper.TempCondition(trait, (Double)pair.getFirst(), (Double)pair.getSecond())));
            }
        }
        return new Instance(player, block, distance, totalEffect, conditions);
    }

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void trigger(ServerPlayerEntity player, BlockPos pos, double distance, double totalEffect) {
        this.func_235959_a_(player, triggerInstance -> triggerInstance.matches(player, pos, distance, totalEffect));
    }

    public static class Instance
    extends CriterionInstance {
        BlockPredicate block;
        MinMaxBounds.FloatBound distance;
        MinMaxBounds.FloatBound totalEffect;
        List<TriggerHelper.TempCondition> conditions;

        public Instance(EntityPredicate.AndPredicate player, BlockPredicate block, double distance, double totalEffect, List<TriggerHelper.TempCondition> conditions) {
            super(ID, player);
            this.block = block;
            this.distance = distance > 0.0 ? new MixinTriggerBounds.MixinFloatBound().atMost(Float.valueOf((float)distance)) : MinMaxBounds.FloatBound.func_211355_b((float)0.0f);
            this.totalEffect = totalEffect < 0.0 ? new MixinTriggerBounds.MixinFloatBound().atMost(Float.valueOf((float)totalEffect)) : MinMaxBounds.FloatBound.func_211355_b((float)((float)totalEffect));
            this.conditions = conditions;
        }

        public boolean matches(ServerPlayerEntity player, BlockPos pos, double distance, double totalEffect) {
            Map<Temperature.Trait, Double> temps = Temperature.getTemperatures((LivingEntity)player);
            return this.distance.func_211354_d((float)distance) && this.totalEffect.func_211354_d((float)totalEffect) && this.block.func_226238_a_(player.func_71121_q(), pos) && this.conditions.stream().allMatch(condition -> condition.matches(temps.getOrDefault(condition.trait(), 0.0)));
        }

        public JsonObject func_230240_a_(ConditionArraySerializer context) {
            JsonObject obj = super.func_230240_a_(context);
            obj.add("distance", this.distance.func_200321_c());
            obj.add("total_effect", this.totalEffect.func_200321_c());
            obj.add("blocks", this.block.func_226236_a_());
            return obj;
        }
    }
}

