/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.event;

import com.momosoftworks.coldsweat.core.init.PotionInit;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PotionRecipes {
    @SubscribeEvent
    public static void register(FMLCommonSetupEvent event) {
        ItemStack awkward = PotionRecipes.createPotion(Potions.field_185233_e);
        ItemStack icePotion = PotionRecipes.createPotion((Potion)PotionInit.ICE_RESISTANCE.get());
        ItemStack longIcePotion = PotionRecipes.createPotion((Potion)PotionInit.LONG_ICE_RESISTANCE.get());
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WorkingBrewingRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{awkward}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.SOUL_SPROUT}), icePotion));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new WorkingBrewingRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{icePotion}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151137_ax}), longIcePotion));
    }

    private static ItemStack createPotion(Potion potion) {
        return PotionUtils.func_185188_a((ItemStack)Items.field_151068_bn.func_190903_i(), (Potion)potion);
    }

    public static class WorkingBrewingRecipe
    extends BrewingRecipe {
        Ingredient potionIn;
        Ingredient reagent;
        ItemStack output;

        public WorkingBrewingRecipe(Ingredient potionIn, Ingredient reagent, ItemStack output) {
            super(potionIn, reagent, output);
            this.potionIn = potionIn;
            this.reagent = reagent;
            this.output = output.func_77946_l();
        }

        public boolean isInput(@Nonnull ItemStack potionIn) {
            if (potionIn == null) {
                return false;
            }
            ItemStack[] matchingStacks = this.potionIn.func_193365_a();
            if (matchingStacks.length == 0) {
                return potionIn.func_190926_b();
            }
            return Arrays.stream(matchingStacks).anyMatch(itemstack -> ItemStack.func_77989_b((ItemStack)itemstack, (ItemStack)potionIn));
        }

        public boolean isIngredient(ItemStack ingredient) {
            if (ingredient == null) {
                return false;
            }
            ItemStack[] matchingStacks = this.reagent.func_193365_a();
            if (matchingStacks.length == 0) {
                return ingredient.func_190926_b();
            }
            return Arrays.stream(matchingStacks).anyMatch(itemstack -> ItemStack.func_77989_b((ItemStack)itemstack, (ItemStack)ingredient));
        }
    }
}

