/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.itemgroup;

import com.momosoftworks.coldsweat.api.event.client.InsulatorTabBuildEvent;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class InsulationItemsGroup
extends ItemGroup {
    public static final InsulationItemsGroup INSULATION_ITEMS = new InsulationItemsGroup("cs_insulation_items");

    public InsulationItemsGroup(String label) {
        super(label);
    }

    public ItemStack func_78016_d() {
        return new ItemStack((IItemProvider)ModItems.CHAMELEON_MOLT);
    }

    public void register() {
    }

    public void func_78018_a(NonNullList<ItemStack> items) {
        List<List> itemCategories = Arrays.asList(InsulationItemsGroup.sort(ConfigSettings.INSULATION_ITEMS.get().entries()), InsulationItemsGroup.sort(ConfigSettings.INSULATING_ARMORS.get().entries()), InsulationItemsGroup.sort(ConfigSettings.INSULATING_CURIOS.get().entries()));
        for (List category : itemCategories) {
            for (ItemStack stack : category) {
                NonNullList dummyList = NonNullList.func_191196_a();
                stack.func_77973_b().func_150895_a(stack.func_77973_b().func_77640_w(), dummyList);
                if (dummyList.isEmpty() || !items.stream().noneMatch(item -> item.func_77969_a((ItemStack)dummyList.get(0)))) continue;
                items.add(dummyList.get(0));
            }
        }
    }

    private static List<ItemStack> sort(Collection<Map.Entry<Item, InsulatorData>> items) {
        ArrayList<Map.Entry<Item, InsulatorData>> list = new ArrayList<Map.Entry<Item, InsulatorData>>(items);
        list.removeIf(entry -> entry.getKey() == null || entry.getKey() == Items.field_190931_a);
        list.sort(Comparator.comparing(entry -> ((Item)entry.getKey()).getTags().stream().map(ResourceLocation::toString).reduce("", (a, b) -> a + b)));
        list.sort(Comparator.comparingInt(entry -> ((InsulatorData)entry.getValue()).insulation().stream().mapToInt(Insulation::getCompareValue).min().orElse(0)));
        list.sort(Comparator.comparing(entry -> entry.getKey() instanceof ArmorItem ? ((ArmorItem)entry.getKey()).func_200880_d().func_200897_d() + (3 - MobEntity.func_184640_d((ItemStack)((Item)entry.getKey()).func_190903_i()).func_188454_b()) : ""));
        InsulatorTabBuildEvent event = new InsulatorTabBuildEvent(list);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getItems().stream().map(entry -> {
            ItemStack stack = new ItemStack((IItemProvider)entry.getKey());
            CompoundNBT nbt = ((InsulatorData)entry.getValue()).item().flatMap(it -> it.nbt().tag(), CompoundNBT::func_197643_a, (a, b) -> {}).orElse(new CompoundNBT());
            if (!nbt.isEmpty()) {
                stack.func_196082_o().func_197643_a(nbt);
            }
            return stack;
        }).collect(Collectors.toList());
    }
}

