/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.impl.RequirementHolder;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.util.AttributeModifierMap;
import com.momosoftworks.coldsweat.data.codec.util.ExtraCodecs;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.EnumHelper;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import com.momosoftworks.coldsweat.util.serialization.StringRepresentable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;

public class ItemTempData
extends ConfigData
implements RequirementHolder {
    final NegatableList<ItemRequirement> item;
    final List<Either<IntegerBounds, SlotType>> slots;
    final double temperature;
    final Temperature.Trait trait;
    final Double maxEffect;
    final double maxTemp;
    final double minTemp;
    final NegatableList<EntityRequirement> entityRequirement;
    final AttributeModifierMap attributeModifiers;
    final Map<ResourceLocation, Double> immuneTempModifiers;
    public static final Codec<ItemTempData> CODEC = ItemTempData.createCodec(RecordCodecBuilder.mapCodec(instance -> instance.group((App)NegatableList.codec(ItemRequirement.CODEC).optionalFieldOf("item", new NegatableList()).forGetter(ItemTempData::item), (App)Codec.either(IntegerBounds.CODEC, SlotType.CODEC).listOf().fieldOf("slots").forGetter(ItemTempData::slots), (App)Codec.DOUBLE.fieldOf("temperature").forGetter(ItemTempData::temperature), (App)Temperature.Trait.CODEC.optionalFieldOf("trait", (Object)Temperature.Trait.WORLD).forGetter(ItemTempData::trait), (App)Codec.DOUBLE.optionalFieldOf("max_effect", (Object)Double.POSITIVE_INFINITY).forGetter(ItemTempData::maxEffect), (App)Codec.DOUBLE.optionalFieldOf("max_temp", (Object)Double.POSITIVE_INFINITY).forGetter(data -> data.maxTemp), (App)Codec.DOUBLE.optionalFieldOf("min_temp", (Object)Double.NEGATIVE_INFINITY).forGetter(data -> data.minTemp), (App)NegatableList.codec(EntityRequirement.getCodec()).optionalFieldOf("entity", new NegatableList()).forGetter(ItemTempData::entityRequirement), (App)AttributeModifierMap.CODEC.optionalFieldOf("attributes", (Object)new AttributeModifierMap()).forGetter(ItemTempData::attributeModifiers), (App)Codec.unboundedMap((Codec)ResourceLocation.field_240908_a_, (Codec)Codec.DOUBLE).optionalFieldOf("immune_temp_modifiers", new HashMap()).forGetter(ItemTempData::immuneTempModifiers)).apply((Applicative)instance, ItemTempData::new)));

    public ItemTempData(NegatableList<ItemRequirement> item, List<Either<IntegerBounds, SlotType>> slots, double temperature, Temperature.Trait trait, Double maxEffect, double maxTemp, double minTemp, NegatableList<EntityRequirement> entityRequirement, AttributeModifierMap attributeModifiers, Map<ResourceLocation, Double> immuneTempModifiers, NegatableList<String> requiredMods) {
        super(requiredMods);
        this.item = item;
        this.slots = slots;
        this.temperature = temperature;
        this.trait = trait;
        this.maxEffect = maxEffect;
        this.maxTemp = maxTemp;
        this.minTemp = minTemp;
        this.entityRequirement = entityRequirement;
        this.attributeModifiers = attributeModifiers;
        this.immuneTempModifiers = immuneTempModifiers;
    }

    public ItemTempData(NegatableList<ItemRequirement> item, List<Either<IntegerBounds, SlotType>> slots, double temperature, Temperature.Trait trait, Double maxEffect, double maxTemp, double minTemp, NegatableList<EntityRequirement> entityRequirement, AttributeModifierMap attributeModifiers, Map<ResourceLocation, Double> immuneTempModifiers) {
        this(item, slots, temperature, trait, maxEffect, maxTemp, minTemp, entityRequirement, attributeModifiers, immuneTempModifiers, new NegatableList<String>());
    }

    public NegatableList<ItemRequirement> item() {
        return this.item;
    }

    public List<Either<IntegerBounds, SlotType>> slots() {
        return this.slots;
    }

    public double temperature() {
        return this.temperature;
    }

    public Temperature.Trait trait() {
        return this.trait;
    }

    public double maxEffect() {
        return this.maxEffect;
    }

    public double maxTemp() {
        return this.maxTemp;
    }

    public double minTemp() {
        return this.minTemp;
    }

    public NegatableList<EntityRequirement> entityRequirement() {
        return this.entityRequirement;
    }

    public AttributeModifierMap attributeModifiers() {
        return this.attributeModifiers;
    }

    public Map<ResourceLocation, Double> immuneTempModifiers() {
        return this.immuneTempModifiers;
    }

    @Override
    public boolean test(Entity entity) {
        return this.entityRequirement.test((T rq) -> rq.test(entity));
    }

    public boolean test(Entity entity, ItemStack stack, int slot, @Nullable EquipmentSlotType equipmentSlot) {
        return this.test(stack, slot, equipmentSlot) && this.test(entity);
    }

    public boolean test(Entity entity, ItemStack stack, SlotType slot) {
        if (!this.test(entity) || !this.item().test((T rq) -> rq.test(stack, true))) {
            return false;
        }
        for (int i = 0; i < this.slots().size(); ++i) {
            Optional slotType = this.slots().get(i).right();
            if (!slotType.isPresent() || !((SlotType)slotType.get()).equals(slot)) continue;
            return true;
        }
        return false;
    }

    public boolean test(ItemStack stack, int slot, @Nullable EquipmentSlotType equipmentSlot) {
        if (!this.item.test((T rq) -> rq.test(stack, true))) {
            return false;
        }
        if (slot == -1 && equipmentSlot == null) {
            return true;
        }
        for (Either<IntegerBounds, SlotType> either : this.slots) {
            if (!(either.left().isPresent() ? slot != -1 && ((IntegerBounds)either.left().get()).test(slot) : either.right().isPresent() && (equipmentSlot != null && ((SlotType)either.right().get()).matches(equipmentSlot) || slot != -1 && ((SlotType)either.right().get()).matches(slot)))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ItemTempData fromToml(List<?> entry) {
        if (entry.size() < 4) {
            ColdSweat.LOGGER.error("Error parsing item temp config: not enough arguments");
            return null;
        }
        NegatableList<Either<ITag<Item>, Item>> items = ConfigHelper.getItems((String)entry.get(0));
        if (items.isEmpty()) {
            return null;
        }
        double temp = ((Number)entry.get(1)).doubleValue();
        SlotType slotType = SlotType.byName((String)entry.get(2));
        if (slotType == null) {
            ColdSweat.LOGGER.error("Error parsing item temp config: \"{}\" is not a valid slot type", entry.get(2));
            return null;
        }
        Temperature.Trait trait = Temperature.Trait.fromID((String)entry.get(3));
        NbtRequirement nbtRequirement = entry.size() > 4 ? new NbtRequirement(NBTHelper.parseCompoundNbt((String)entry.get(4))) : new NbtRequirement(new CompoundNBT());
        double maxEffect = entry.size() > 5 ? ((Number)entry.get(5)).doubleValue() : Double.POSITIVE_INFINITY;
        double tempLimit = entry.size() > 6 ? ((Number)entry.get(6)).doubleValue() : Double.POSITIVE_INFINITY;
        double maxTemp = temp > 0.0 ? tempLimit : Double.POSITIVE_INFINITY;
        double minTemp = temp < 0.0 ? -tempLimit : Double.NEGATIVE_INFINITY;
        ItemRequirement itemRequirement = new ItemRequirement(items, nbtRequirement);
        return new ItemTempData(new NegatableList<ItemRequirement>(itemRequirement), Arrays.asList(Either.right((Object)slotType)), temp, trait, maxEffect, maxTemp, minTemp, new NegatableList<EntityRequirement>(), new AttributeModifierMap(), new FastMap<ResourceLocation, Double>());
    }

    public String getSlotRangeName() {
        if (this.slots.size() != 1 || this.slots.get(0).left().isPresent()) {
            return "";
        }
        return ((SlotType)this.slots.get(0).right().get()).func_176610_l();
    }

    public Codec<ItemTempData> getCodec() {
        return CODEC;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ItemTempData that = (ItemTempData)obj;
        return super.equals(obj) && this.temperature == that.temperature && this.item.equals(that.item) && this.slots.equals(that.slots) && this.trait.equals(that.trait) && this.maxEffect.equals(that.maxEffect) && this.entityRequirement.equals(that.entityRequirement);
    }

    public static enum SlotType implements StringRepresentable
    {
        HEAD("head", Arrays.asList(Either.right((Object)EquipmentSlotType.HEAD))),
        CHEST("chest", Arrays.asList(Either.right((Object)EquipmentSlotType.CHEST))),
        LEGS("legs", Arrays.asList(Either.right((Object)EquipmentSlotType.LEGS))),
        FEET("feet", Arrays.asList(Either.right((Object)EquipmentSlotType.FEET))),
        INVENTORY("inventory", Arrays.asList(Either.left((Object)IntegerBounds.NONE))),
        HOTBAR("hotbar", Arrays.asList(Either.left((Object)new IntegerBounds(0, 8)))),
        CURIO("curio", Arrays.asList(new Either[0])),
        HAND("hand", Arrays.asList(Either.right((Object)EquipmentSlotType.MAINHAND), Either.right((Object)EquipmentSlotType.OFFHAND)));

        public static final Codec<SlotType> CODEC;
        private final String name;
        private final List<Either<IntegerBounds, EquipmentSlotType>> slots;

        private SlotType(String name, List<Either<IntegerBounds, EquipmentSlotType>> slots) {
            this.name = name;
            this.slots = slots;
        }

        public List<Either<IntegerBounds, EquipmentSlotType>> getSlots() {
            return this.slots;
        }

        public boolean matches(int slotId) {
            for (int i = 0; i < this.slots.size(); ++i) {
                Either<IntegerBounds, EquipmentSlotType> either = this.slots.get(i);
                if (!either.left().isPresent() || !((IntegerBounds)either.left().get()).test(slotId)) continue;
                return true;
            }
            return false;
        }

        public boolean matches(EquipmentSlotType slot) {
            for (int i = 0; i < this.slots.size(); ++i) {
                Either<IntegerBounds, EquipmentSlotType> either = this.slots.get(i);
                if (!either.right().isPresent() || !((EquipmentSlotType)either.right().get()).equals((Object)slot)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String func_176610_l() {
            return this.name;
        }

        public static SlotType byName(String name) {
            return (SlotType)EnumHelper.byName((Enum[])SlotType.values(), (String)name);
        }

        public static SlotType fromEquipment(EquipmentSlotType slot) {
            switch (slot) {
                case HEAD: {
                    return HEAD;
                }
                case CHEST: {
                    return CHEST;
                }
                case LEGS: {
                    return LEGS;
                }
                case FEET: {
                    return FEET;
                }
            }
            return HAND;
        }

        static {
            CODEC = ExtraCodecs.enumIgnoreCase((Enum[])SlotType.values());
        }
    }
}

