/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.util.ExtraCodecs;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.StateHolder;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockRequirement {
    private final NegatableList<Either<ITag<Block>, Block>> blocks;
    private final StateRequirement state;
    private final NbtRequirement nbt;
    private final List<Direction> sturdyFaces;
    private final Optional<Boolean> replaceable;
    public static final BlockRequirement NONE = new BlockRequirement(new NegatableList<Either<ITag<Block>, Block>>(), StateRequirement.NONE, NbtRequirement.NONE, Arrays.asList(new Direction[0]), Optional.empty());
    public static final Codec<BlockRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NegatableList.listCodec(ConfigHelper.tagOrBuiltinCodec(Registry.field_239711_l_, Registry.field_212618_g)).optionalFieldOf("blocks", new NegatableList()).forGetter(predicate -> predicate.blocks), (App)StateRequirement.CODEC.optionalFieldOf("state", (Object)StateRequirement.NONE).forGetter(predicate -> predicate.state), (App)NbtRequirement.CODEC.optionalFieldOf("nbt", (Object)NbtRequirement.NONE).forGetter(predicate -> predicate.nbt), (App)Codec.STRING.xmap(Direction::func_176739_a, Direction::func_176742_j).listOf().optionalFieldOf("sturdy_faces", Arrays.asList(new Direction[0])).forGetter(predicate -> predicate.sturdyFaces), (App)Codec.BOOL.optionalFieldOf("replaceable").forGetter(predicate -> predicate.replaceable)).apply((Applicative)instance, BlockRequirement::new));

    public BlockRequirement(NegatableList<Either<ITag<Block>, Block>> blocks, StateRequirement state, NbtRequirement nbt, List<Direction> sturdyFaces, Optional<Boolean> replaceable) {
        this.blocks = blocks;
        this.state = state;
        this.nbt = nbt;
        this.sturdyFaces = sturdyFaces;
        this.replaceable = replaceable;
    }

    public BlockRequirement(List<Either<ITag<Block>, Block>> blocks) {
        this(new NegatableList<Either<ITag<Block>, Block>>(blocks), StateRequirement.NONE, NbtRequirement.NONE, Arrays.asList(new Direction[0]), Optional.empty());
    }

    public NegatableList<Either<ITag<Block>, Block>> blocks() {
        return this.blocks;
    }

    public StateRequirement state() {
        return this.state;
    }

    public NbtRequirement nbt() {
        return this.nbt;
    }

    public List<Direction> sturdyFaces() {
        return this.sturdyFaces;
    }

    public Optional<Boolean> replaceable() {
        return this.replaceable;
    }

    public boolean test(World level, BlockPos pos, BlockState state) {
        TileEntity blockentity;
        if (!level.func_195588_v(pos)) {
            return true;
        }
        if (!this.blocks.test(either -> (Boolean)either.map(arg_0 -> ((BlockState)state).func_235714_a_(arg_0), arg_0 -> ((BlockState)state).func_203425_a(arg_0)))) {
            return false;
        }
        if (!this.state.test(state)) {
            return false;
        }
        if (!this.nbt.isEmpty() && (blockentity = level.func_175625_s(pos)) != null && !this.nbt.test(blockentity.func_189515_b(new CompoundNBT()))) {
            return false;
        }
        if (!this.sturdyFaces.isEmpty() && this.sturdyFaces.stream().noneMatch(face -> state.func_224755_d((IBlockReader)level, pos, face))) {
            return false;
        }
        return !this.replaceable.isPresent() || state.func_196958_f() || state.func_185904_a().func_76222_j();
    }

    public boolean test(World level, BlockPos pos) {
        if (!level.func_195588_v(pos)) {
            return true;
        }
        return this.test(level, pos, level.func_180495_p(pos));
    }

    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlockRequirement that = (BlockRequirement)obj;
        return this.blocks.equals(that.blocks) && this.state.equals(that.state) && this.nbt.equals(that.nbt) && this.sturdyFaces.equals(that.sturdyFaces) && this.replaceable.equals(that.replaceable);
    }

    public static class StateRequirement {
        public Map<String, Object> properties;
        public static final Codec<StateRequirement> CODEC = Codec.unboundedMap((Codec)Codec.STRING, ExtraCodecs.anyOf(new Codec[]{Codec.BOOL, IntegerBounds.CODEC, Codec.STRING, Codec.STRING.listOf()})).xmap(StateRequirement::new, req -> req.properties);
        public static final StateRequirement NONE = new StateRequirement(new HashMap<String, Object>());

        public StateRequirement(Map<String, Object> properties) {
            this.properties = properties;
        }

        public boolean test(BlockState state) {
            return this.test(state.func_177230_c().func_176194_O(), state);
        }

        public boolean test(FluidState state) {
            return this.test(state.func_206886_c().func_207182_e(), state);
        }

        public <S extends StateHolder<?, S>> boolean test(StateContainer<?, S> stateDefinition, S state) {
            block0: for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                Property property = stateDefinition.func_185920_a(key);
                if (property == null) {
                    return false;
                }
                if (value instanceof IntegerBounds) {
                    IntegerBounds bounds = (IntegerBounds)value;
                    if (property.func_177700_c().contains(bounds.min) && property.func_177700_c().contains(bounds.max) && bounds.test((Integer)state.func_177229_b(property))) continue;
                    return false;
                }
                if (value instanceof List) {
                    List list = (List)value;
                    if (list.isEmpty()) continue;
                    for (Object val : list) {
                        if (!state.func_177229_b(property).toString().equals(val.toString())) continue;
                        continue block0;
                    }
                    return false;
                }
                if (value instanceof Boolean) {
                    Boolean bool = (Boolean)value;
                    if (property.func_177700_c().contains(bool) && state.func_177229_b(property).equals(bool)) continue;
                    return false;
                }
                if (property.func_177700_c().contains(value) && state.func_177229_b(property).toString().equals(value.toString())) continue;
                return false;
            }
            return true;
        }

        public static StateRequirement fromToml(String[] entries, Block block) {
            return StateRequirement.fromToml(Arrays.asList(entries), block);
        }

        public static StateRequirement fromToml(List<String> entries, Block block) {
            HashMap<String, Object> blockPredicates = new HashMap<String, Object>();
            for (String predicate : entries) {
                String[] pair = predicate.split("=");
                String key = pair[0];
                String value = pair[1];
                Property property = block.func_176194_O().func_185920_a(key);
                if (property == null) continue;
                property.func_185929_b(value).ifPresent(propertyValue -> blockPredicates.put(key, propertyValue));
            }
            return new StateRequirement(blockPredicates);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            StateRequirement that = (StateRequirement)obj;
            return this.properties.equals(that.properties);
        }
    }
}

