/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.EnchantmentRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tags.ITag;
import net.minecraft.util.registry.Registry;

public class ItemRequirement {
    private final NegatableList<Either<ITag<Item>, Item>> items;
    private final IntegerBounds count;
    private final IntegerBounds durability;
    private final NegatableList<EnchantmentRequirement> enchantments;
    private final Optional<Potion> potion;
    private final NbtRequirement nbt;
    private final Optional<Predicate<ItemStack>> predicate;
    public static final Item WILDCARD_ITEM = null;
    private static final Codec<Either<ITag<Item>, Item>> ITEM_CODEC = Codec.either(ConfigHelper.tagOrBuiltinCodec(Registry.field_239714_o_, Registry.field_212630_s), (Codec)Codec.STRING).xmap(itemOrString -> {
        if (itemOrString.left().isPresent()) {
            return (Either)itemOrString.left().get();
        }
        String itemName = (String)itemOrString.right().get();
        if (itemName.equals("*")) {
            return Either.right((Object)WILDCARD_ITEM);
        }
        throw new IllegalArgumentException("Could not find item: " + itemName);
    }, tagOrItem -> (Either)tagOrItem.map(left -> Either.left((Object)Either.left((Object)left)), right -> right == WILDCARD_ITEM ? Either.right((Object)"*") : Either.left((Object)Either.right((Object)right))));
    public static final Codec<ItemRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NegatableList.listCodec(ITEM_CODEC).fieldOf("items").forGetter(predicate -> predicate.items), (App)IntegerBounds.CODEC.optionalFieldOf("count", (Object)IntegerBounds.NONE).forGetter(predicate -> predicate.count), (App)IntegerBounds.CODEC.optionalFieldOf("durability", (Object)IntegerBounds.NONE).forGetter(predicate -> predicate.durability), (App)NegatableList.listCodec(EnchantmentRequirement.CODEC).optionalFieldOf("enchantments", new NegatableList()).forGetter(predicate -> predicate.enchantments), (App)Registry.field_212621_j.optionalFieldOf("potion").forGetter(predicate -> predicate.potion), (App)NbtRequirement.CODEC.optionalFieldOf("nbt", (Object)new NbtRequirement()).forGetter(predicate -> predicate.nbt)).apply((Applicative)instance, ItemRequirement::new));
    public static final ItemRequirement NONE = new ItemRequirement(new NegatableList<Either<ITag<Item>, Item>>(), IntegerBounds.NONE, IntegerBounds.NONE, new NegatableList<EnchantmentRequirement>(), Optional.empty(), new NbtRequirement());

    public ItemRequirement(NegatableList<Either<ITag<Item>, Item>> items, IntegerBounds count, IntegerBounds durability, NegatableList<EnchantmentRequirement> enchantments, Optional<Potion> potion, NbtRequirement nbt, Optional<Predicate<ItemStack>> predicate) {
        this.items = items;
        this.count = count;
        this.durability = durability;
        this.enchantments = enchantments;
        this.potion = potion;
        this.nbt = nbt;
        this.predicate = predicate;
    }

    public ItemRequirement(NegatableList<Either<ITag<Item>, Item>> items, IntegerBounds count, IntegerBounds durability, NegatableList<EnchantmentRequirement> enchantments, Optional<Potion> potion, NbtRequirement nbt) {
        this(items, count, durability, enchantments, potion, nbt, Optional.empty());
    }

    public ItemRequirement(NegatableList<Either<ITag<Item>, Item>> items, NbtRequirement nbt) {
        this(items, IntegerBounds.NONE, IntegerBounds.NONE, new NegatableList<EnchantmentRequirement>(), Optional.empty(), nbt);
    }

    public ItemRequirement(Collection<Item> items, Predicate<ItemStack> predicate) {
        this(new NegatableList<Either<ITag<Item>, Item>>(items.stream().map(Either::right).collect(Collectors.toList())), IntegerBounds.NONE, IntegerBounds.NONE, new NegatableList<EnchantmentRequirement>(), Optional.empty(), new NbtRequirement(), Optional.ofNullable(predicate));
    }

    public ItemRequirement(Predicate<ItemStack> predicate) {
        this(new NegatableList<Either<ITag<Item>, Item>>(), IntegerBounds.NONE, IntegerBounds.NONE, new NegatableList<EnchantmentRequirement>(), Optional.empty(), new NbtRequirement(), Optional.of(predicate));
    }

    public NegatableList<Either<ITag<Item>, Item>> items() {
        return this.items;
    }

    public IntegerBounds count() {
        return this.count;
    }

    public IntegerBounds durability() {
        return this.durability;
    }

    public NegatableList<EnchantmentRequirement> enchantments() {
        return this.enchantments;
    }

    public Optional<Potion> potion() {
        return this.potion;
    }

    public NbtRequirement nbt() {
        return this.nbt;
    }

    public Optional<Predicate<ItemStack>> predicate() {
        return this.predicate;
    }

    public boolean test(ItemStack stack, boolean ignoreCount) {
        if (stack.func_190926_b() && !this.items.isEmpty()) {
            return false;
        }
        if (!this.items.test(either -> (Boolean)either.map(tag -> tag.func_230235_a_((Object)stack.func_77973_b()), right -> right == WILDCARD_ITEM || stack.func_77973_b() == right))) {
            return false;
        }
        if (this.predicate.isPresent()) {
            return this.predicate.get().test(stack);
        }
        if (!this.nbt.test(stack.func_77978_p())) {
            return false;
        }
        if (!ignoreCount && !this.count.test(stack.func_190916_E())) {
            return false;
        }
        if (!this.durability.test(stack.func_77958_k() - stack.func_77952_i())) {
            return false;
        }
        if (this.potion.isPresent() && !this.potion.get().func_185170_a().equals(PotionUtils.func_185191_c((ItemStack)stack).func_185170_a())) {
            return false;
        }
        if (!this.nbt.test(stack.func_77978_p())) {
            return false;
        }
        if (!this.enchantments.isEmpty()) {
            Map stackEnchantments = EnchantmentHelper.func_226652_a_((ListNBT)stack.func_77986_q());
            stackEnchantments.putAll(EnchantmentHelper.func_226652_a_((ListNBT)EnchantedBookItem.func_92110_g((ItemStack)stack)));
            if (!this.enchantments.test(enchantment -> enchantment.test(stackEnchantments))) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ItemRequirement that = (ItemRequirement)obj;
        return this.items.equals(that.items) && this.count.equals(that.count) && this.durability.equals(that.durability) && this.enchantments.equals(that.enchantments) && this.potion.equals(that.potion) && this.nbt.equals(that.nbt) && this.predicate.equals(that.predicate);
    }
}

