/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.momosoftworks.coldsweat.common.event.IceBreakingEvents;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.loot.ModLootTables;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.IceBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class MixinIce {

    @Mixin(value={AbstractBlock.class})
    public static class AddDrops {
        @Inject(method={"getDrops"}, at={@At(value="HEAD")}, cancellable=true)
        private void addDrops(BlockState state, LootContext.Builder params, CallbackInfoReturnable<List<ItemStack>> cir) {
            ItemStack stack = (ItemStack)params.func_216019_b(LootParameters.field_216289_i);
            if (stack == null) {
                return;
            }
            if (ConfigSettings.USE_CUSTOM_ICE_DROPS.get().booleanValue() && IceBreakingEvents.isModifiableIceBlock(state) && stack.func_150998_b(state)) {
                cir.setReturnValue(ModLootTables.getBlockDropsLootTable(params.func_216018_a(), new BlockPos((Vector3d)params.func_216024_a(LootParameters.field_237457_g_)), state, CSMath.getIfNotNull(params.func_216019_b(LootParameters.field_216281_a), entity -> entity instanceof PlayerEntity ? (PlayerEntity)entity : null, null), IceBreakingEvents.getLootTableForIce(state)));
            }
        }
    }

    @Mixin(value={IceBlock.class})
    public static class NoWaterOnBreak {
        @Inject(method={"playerDestroy"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/BlockState;")}, cancellable=true)
        private void noWater(World pLevel, PlayerEntity pPlayer, BlockPos pPos, BlockState pState, TileEntity pTe, ItemStack pStack, CallbackInfo ci) {
            if (ConfigSettings.USE_CUSTOM_ICE_DROPS.get().booleanValue()) {
                ci.cancel();
            }
        }
    }
}

