/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.Overlays;
import com.momosoftworks.coldsweat.common.item.ThermometerItem;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.ItemFrameRenderer;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemFrameRenderer.class})
public class MixinItemFrameLabel {
    private static ItemStack ITEM = ItemStack.field_190927_a;
    private static ItemFrameEntity ENTITY = null;

    @Inject(method={"renderNameTag(Lnet/minecraft/entity/item/ItemFrameEntity;Lnet/minecraft/util/text/ITextComponent;Lcom/mojang/blaze3d/matrix/MatrixStack;Lnet/minecraft/client/renderer/IRenderTypeBuffer;I)V"}, at={@At(value="HEAD")})
    private void storeItemStack(ItemFrameEntity itemFrame, ITextComponent pDisplayName, MatrixStack pMatrixStack, IRenderTypeBuffer pBuffer, int pPackedLight, CallbackInfo ci) {
        ITEM = itemFrame.func_82335_i();
        ENTITY = itemFrame;
    }

    @ModifyArg(method={"renderNameTag(Lnet/minecraft/entity/item/ItemFrameEntity;Lnet/minecraft/util/text/ITextComponent;Lcom/mojang/blaze3d/matrix/MatrixStack;Lnet/minecraft/client/renderer/IRenderTypeBuffer;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/EntityRenderer;renderNameTag(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/text/ITextComponent;Lcom/mojang/blaze3d/matrix/MatrixStack;Lnet/minecraft/client/renderer/IRenderTypeBuffer;I)V"))
    private ITextComponent modifyItemFrameLabel(ITextComponent original) {
        if (ITEM.func_77973_b() instanceof ThermometerItem && Minecraft.func_71410_x().field_71441_e != null && ENTITY != null) {
            double minTemp = ConfigSettings.MIN_TEMP.get();
            double maxTemp = ConfigSettings.MAX_TEMP.get();
            double worldTemp = WorldHelper.getTemperatureAt((World)Minecraft.func_71410_x().field_71441_e, ENTITY.func_233580_cy_());
            boolean celsius = ConfigSettings.CELSIUS.get();
            Style tempColor = Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)Overlays.getWorldTempColor(worldTemp, minTemp, maxTemp)));
            int convertedTemp = (int)Temperature.convert(worldTemp, Temperature.Units.MC, celsius ? Temperature.Units.C : Temperature.Units.F, true) + ConfigSettings.TEMP_OFFSET.get();
            return new StringTextComponent(convertedTemp + " " + (celsius ? Temperature.Units.C.getFormattedName() : Temperature.Units.F.getFormattedName())).func_240703_c_(tempColor);
        }
        return original;
    }

    @Redirect(method={"shouldShowName(Lnet/minecraft/entity/item/ItemFrameEntity;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;hasCustomHoverName()Z"))
    private boolean alwaysShowThermometerName(ItemStack instance) {
        if (instance.func_77973_b() instanceof ThermometerItem) {
            return true;
        }
        return instance.func_82837_s();
    }
}

