/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.render;

import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class ContainerOpenersCounter {
    private static final int CHECK_TICK_DELAY = 5;
    private int openCount;

    protected abstract void onOpen(World var1, BlockPos var2, BlockState var3);

    protected abstract void onClose(World var1, BlockPos var2, BlockState var3);

    protected abstract void openerCountChanged(World var1, BlockPos var2, BlockState var3, int var4, int var5);

    protected abstract boolean isOwnContainer(PlayerEntity var1);

    public void incrementOpeners(PlayerEntity player, World level, BlockPos pos, BlockState state) {
        int i;
        if ((i = this.openCount++) == 0) {
            this.onOpen(level, pos, state);
            level.func_175641_c(pos, state.func_177230_c(), 1, this.openCount);
            ContainerOpenersCounter.scheduleRecheck(level, pos, state);
        }
        this.openerCountChanged(level, pos, state, i, this.openCount);
    }

    public void decrementOpeners(PlayerEntity player, World level, BlockPos pos, BlockState state) {
        int i = this.openCount--;
        if (this.openCount == 0) {
            this.onClose(level, pos, state);
            level.func_175641_c(pos, state.func_177230_c(), 1, this.openCount);
        }
        this.openerCountChanged(level, pos, state, i, this.openCount);
    }

    private int getOpenCount(World level, BlockPos pos) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        float f = 5.0f;
        AxisAlignedBB aabb = new AxisAlignedBB((double)((float)i - 5.0f), (double)((float)j - 5.0f), (double)((float)k - 5.0f), (double)((float)(i + 1) + 5.0f), (double)((float)(j + 1) + 5.0f), (double)((float)(k + 1) + 5.0f));
        return level.func_217394_a(EntityType.field_200729_aH, aabb, this::isOwnContainer).size();
    }

    public void recheckOpeners(World level, BlockPos pos, BlockState state) {
        int j = this.openCount;
        int i = this.getOpenCount(level, pos);
        if (j != i) {
            boolean flag1;
            boolean flag = i != 0;
            boolean bl = flag1 = j != 0;
            if (flag && !flag1) {
                this.onOpen(level, pos, state);
                level.func_175641_c(pos, state.func_177230_c(), 1, this.openCount);
            } else if (!flag) {
                this.onClose(level, pos, state);
                level.func_175641_c(pos, state.func_177230_c(), 1, this.openCount);
            }
            this.openCount = i;
        }
        this.openerCountChanged(level, pos, state, j, i);
        if (i > 0) {
            ContainerOpenersCounter.scheduleRecheck(level, pos, state);
        }
    }

    public int getOpenerCount() {
        return this.openCount;
    }

    private static void scheduleRecheck(World level, BlockPos pos, BlockState state) {
        if (level instanceof ServerWorld) {
            state.func_177230_c().func_225534_a_(state, (ServerWorld)level, pos, level.field_73012_v);
        }
    }
}

