/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.config.ConfigLoadingHandler;
import com.momosoftworks.coldsweat.data.RegistryHolder;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.math.FastMultiMap;
import com.momosoftworks.coldsweat.util.math.RegistryMultiMap;
import com.momosoftworks.coldsweat.util.serialization.DynamicHolder;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.util.TriConsumer;

public class ConfigHelper {
    private ConfigHelper() {
    }

    public static <T> NegatableList<T> parseRegistryItems(RegistryKey<Registry<T>> registry, DynamicRegistries registryAccess, String objects) {
        return ConfigHelper.parseRegistryItems(registry, registryAccess, objects.split(","));
    }

    public static <T> NegatableList<T> parseRegistryItems(RegistryKey<Registry<T>> registry, DynamicRegistries registryAccess, String[] objects) {
        NegatableList registryList = new NegatableList();
        MutableRegistry reg = registryAccess.func_243612_b(registry);
        for (String objString : objects) {
            ResourceLocation id;
            Optional obj;
            boolean negate = objString.startsWith("!");
            if (negate) {
                objString = objString.substring(1);
            }
            if (!(obj = reg.func_241873_b(id = new ResourceLocation(objString))).isPresent()) {
                ColdSweat.LOGGER.error("Error parsing config: \"{}\" does not exist", (Object)objString);
                continue;
            }
            registryList.add(obj.get(), negate);
        }
        return registryList;
    }

    public static <T> NegatableList<Either<ITag<T>, T>> parseTaggableRegistryItems(RegistryKey<Registry<T>> registry, DynamicRegistries registryAccess, String objects) {
        return ConfigHelper.parseTaggableRegistryItems(registry, registryAccess, objects.split(","));
    }

    public static <T> NegatableList<Either<ITag<T>, T>> parseTaggableRegistryItems(RegistryKey<Registry<T>> registry, DynamicRegistries registryAccess, String[] objects) {
        NegatableList<Either<ITag<Either>, Either>> registryList = new NegatableList<Either<ITag<Either>, Either>>();
        MutableRegistry reg = registryAccess.func_243612_b(registry);
        for (String objString : objects) {
            boolean negate = objString.startsWith("!");
            if (negate) {
                objString = objString.substring(1);
            }
            if (objString.startsWith("#")) {
                ITagCollection<T> tags = ConfigHelper.getTagsForRegistry(registry);
                if (tags == null) continue;
                String tagID = objString.replace("#", "");
                registryList.add(Either.left((Object)ConfigHelper.getTagsForRegistry(registry).func_199910_a(new ResourceLocation(tagID))), negate);
                continue;
            }
            ResourceLocation id = new ResourceLocation(objString);
            Optional obj = reg.func_241873_b(id);
            if (!reg.func_212607_c(id) || !obj.isPresent()) {
                ColdSweat.LOGGER.error("Error parsing config: {} \"{}\" does not exist", (Object)registry.func_240901_a_().func_110623_a(), (Object)objString);
                continue;
            }
            registryList.add(Either.right(obj.get()), negate);
        }
        return registryList;
    }

    public static <T> ITagCollection<T> getTagsForRegistry(RegistryKey<Registry<T>> registry) {
        if (registry.equals((Object)Registry.field_239714_o_)) {
            return ItemTags.func_199903_a();
        }
        if (registry.equals((Object)Registry.field_239711_l_)) {
            return BlockTags.func_199896_a();
        }
        if (registry.equals((Object)Registry.field_239709_j_)) {
            return FluidTags.func_226157_a_();
        }
        if (registry.equals((Object)Registry.field_239713_n_)) {
            return EntityTypeTags.func_219762_a();
        }
        return null;
    }

    public static <T> ITagCollection<T> getTagsForObject(T object) {
        if (object instanceof Item) {
            return ItemTags.func_199903_a();
        }
        if (object instanceof Block) {
            return BlockTags.func_199896_a();
        }
        if (object instanceof Fluid) {
            return FluidTags.func_226157_a_();
        }
        if (object instanceof EntityType) {
            return EntityTypeTags.func_219762_a();
        }
        return null;
    }

    public static <T extends IForgeRegistryEntry<T>> NegatableList<Either<ITag<T>, T>> parseBuiltinItems(RegistryKey<Registry<T>> registryKey, IForgeRegistry<T> registry, String objects) {
        return ConfigHelper.parseBuiltinItems(registryKey, registry, objects.split(","));
    }

    public static <T extends IForgeRegistryEntry<T>> NegatableList<Either<ITag<T>, T>> parseBuiltinItems(RegistryKey<Registry<T>> registryKey, IForgeRegistry<T> registry, String[] objects) {
        NegatableList<Either<ITag<Either>, Either>> registryList = new NegatableList<Either<ITag<Either>, Either>>();
        for (String objString : objects) {
            boolean negate = objString.startsWith("!");
            if (negate) {
                objString = objString.substring(1);
            }
            if (objString.startsWith("#")) {
                String tagID = objString.replace("#", "");
                ITagCollection<T> tags = ConfigHelper.getTagsForRegistry(registryKey);
                if (tags == null) {
                    ColdSweat.LOGGER.error("Error parsing config: {} does not support tags", (Object)registryKey.func_240901_a_().func_110623_a());
                    continue;
                }
                ITag tag = tags.func_199910_a(new ResourceLocation(tagID));
                if (tag == null) {
                    ColdSweat.LOGGER.error("Error parsing {} config: tag \"{}\" does not exist", (Object)registryKey.func_240901_a_().func_110623_a(), (Object)tagID);
                    continue;
                }
                registryList.add(Either.left((Object)tag), negate);
                continue;
            }
            ResourceLocation id = new ResourceLocation(objString);
            if (!registry.containsKey(id)) {
                ColdSweat.LOGGER.error("Error parsing config: {} \"{}\" does not exist", (Object)registryKey.func_240901_a_().func_110623_a(), (Object)objString);
                continue;
            }
            IForgeRegistryEntry obj = registry.getValue(id);
            registryList.add(Either.right((Object)obj), negate);
        }
        return registryList;
    }

    public static NegatableList<Either<ITag<Block>, Block>> getBlocks(String blocks) {
        return ConfigHelper.getBlocks(blocks.split(","));
    }

    public static NegatableList<Either<ITag<Block>, Block>> getBlocks(String[] blocks) {
        return ConfigHelper.parseBuiltinItems(Registry.field_239711_l_, ForgeRegistries.BLOCKS, blocks);
    }

    public static NegatableList<Either<ITag<Item>, Item>> getItems(String items) {
        return ConfigHelper.getItems(items.split(","));
    }

    public static NegatableList<Either<ITag<Item>, Item>> getItems(String[] items) {
        return ConfigHelper.parseBuiltinItems(Registry.field_239714_o_, ForgeRegistries.ITEMS, items);
    }

    public static NegatableList<Either<ITag<EntityType<?>>, EntityType<?>>> getEntityTypes(String entities) {
        return ConfigHelper.getEntityTypes(entities.split(","));
    }

    public static NegatableList<Either<ITag<EntityType<?>>, EntityType<?>>> getEntityTypes(String[] entities) {
        return ConfigHelper.parseBuiltinItems(Registry.field_239713_n_, ForgeRegistries.ENTITIES, entities);
    }

    public static <K extends IForgeRegistryEntry<K>, V extends ConfigData> Multimap<K, V> parseTomlRegistry(ForgeConfigSpec.ConfigValue<List<? extends List<?>>> config, Function<List<?>, V> tomlParser, Function<V, NegatableList<Either<ITag<K>, K>>> keyListGetter, IForgeRegistry<K> keyRegistry, RegistryHolder<V> valueRegistry) {
        RegistryMultiMap dataMap = new RegistryMultiMap();
        for (List entry : (List)config.get()) {
            ConfigData data = (ConfigData)tomlParser.apply(entry);
            if (data == null) continue;
            data.setConfigType(ConfigData.Type.TOML);
            RegistryHelper.mapTaggableList(keyListGetter.apply(data)).forEach(ent -> dataMap.put(ent, data));
        }
        ConfigLoadingHandler.modifyEntries(dataMap, valueRegistry);
        return dataMap;
    }

    public static <K extends IForgeRegistryEntry<K>, V extends ConfigData> Map<K, V> parseTomlRegistryUnique(ForgeConfigSpec.ConfigValue<List<? extends List<?>>> config, Function<List<?>, V> tomlParser, Function<V, List<Either<ITag<K>, K>>> keyListGetter, IForgeRegistry<K> keyRegistry, RegistryHolder<V> valueRegistry) {
        HashMap dataMap = new HashMap();
        for (List entry : (List)config.get()) {
            ConfigData data = (ConfigData)tomlParser.apply(entry);
            if (data == null) continue;
            data.setConfigType(ConfigData.Type.TOML);
            RegistryHelper.mapTaggableList(keyListGetter.apply(data)).forEach(ent -> dataMap.put(ent, data));
        }
        ConfigLoadingHandler.modifyEntries(dataMap, valueRegistry);
        return dataMap;
    }

    private static <K extends IForgeRegistryEntry<K>, V> void putRegistryEntries(Multimap<K, V> map, IForgeRegistry<K> registry, List<Either<ITag<K>, K>> list, V data) {
        RegistryHelper.mapTaggableList(list).forEach(entry -> map.put(entry, data));
    }

    public static <K, V extends ConfigData> Map<K, V> getRegistryMap(List<? extends List<?>> source, DynamicRegistries dynamicRegistries, RegistryKey<Registry<K>> keyRegistry, Function<List<?>, V> valueCreator, Function<V, NegatableList<Either<ITag<K>, K>>> taggedListGetter) {
        return ConfigHelper.getRegistryMapLike(source, dynamicRegistries, keyRegistry, valueCreator, taggedListGetter, FastMap::new, FastMap::put);
    }

    public static <K, V extends ConfigData> Map<K, V> getRegistryMap(List<? extends List<?>> source, RegistryKey<Registry<K>> keyRegistry, Function<List<?>, V> valueCreator, Function<V, NegatableList<K>> taggedListGetter) {
        return ConfigHelper.getRegistryMapLike(source, null, keyRegistry, valueCreator, v -> new NegatableList(((NegatableList)taggedListGetter.apply(v)).flatList().stream().map(Either::right).collect(Collectors.toList())), FastMap::new, FastMap::put);
    }

    public static <K, V extends ConfigData> Multimap<K, V> getRegistryMultimap(List<? extends List<?>> source, DynamicRegistries dynamicRegistries, RegistryKey<Registry<K>> keyRegistry, Function<List<?>, V> valueCreator, Function<V, NegatableList<Either<ITag<K>, K>>> taggedListGetter) {
        return ConfigHelper.getRegistryMapLike(source, dynamicRegistries, keyRegistry, valueCreator, taggedListGetter, FastMultiMap::new, FastMultiMap::put);
    }

    public static <K, V extends ConfigData> Multimap<K, V> getRegistryMultimap(List<? extends List<?>> source, RegistryKey<Registry<K>> keyRegistry, Function<List<?>, V> valueCreator, Function<V, NegatableList<K>> taggedListGetter) {
        return ConfigHelper.getRegistryMapLike(source, null, keyRegistry, valueCreator, v -> new NegatableList(((NegatableList)taggedListGetter.apply(v)).flatList().stream().map(Either::right).collect(Collectors.toList())), FastMultiMap::new, FastMultiMap::put);
    }

    private static <K, V extends ConfigData, M> M getRegistryMapLike(List<? extends List<?>> source, DynamicRegistries dynamicRegistries, RegistryKey<Registry<K>> keyRegistry, Function<List<?>, V> valueCreator, Function<V, NegatableList<Either<ITag<K>, K>>> listGetter, Supplier<M> mapSupplier, TriConsumer<M, K, V> mapAdder) {
        M map = mapSupplier.get();
        for (List<?> entry : source) {
            ConfigData data = (ConfigData)valueCreator.apply(entry);
            if (data != null) {
                data.setConfigType(ConfigData.Type.TOML);
                for (Object key : RegistryHelper.mapTaggableList(listGetter.apply(data))) {
                    mapAdder.accept(map, key, (Object)data);
                }
                continue;
            }
            ColdSweat.LOGGER.error("Error parsing {} config \"{}\"", (Object)keyRegistry.func_240901_a_(), (Object)entry.toString());
        }
        return map;
    }

    public static <T extends IForgeRegistryEntry<T>> Codec<Either<ITag<T>, T>> tagOrBuiltinCodec(RegistryKey<Registry<T>> vanillaRegistry, Registry<T> forgeRegistry) {
        ITagCollection vanillaTags = ConfigHelper.getTagsForRegistry(vanillaRegistry);
        return Codec.either((Codec)Codec.STRING.comapFlatMap(str -> {
            if (!str.startsWith("#")) {
                return DataResult.error((String)("Not a tag key: " + str));
            }
            ResourceLocation itemLocation = new ResourceLocation(str.replace("#", ""));
            return DataResult.success((Object)vanillaTags.func_199910_a(itemLocation));
        }, key -> "#" + vanillaTags.func_232973_a_(key)), forgeRegistry);
    }

    public static <T> Codec<T> dynamicCodec(RegistryKey<Registry<T>> vanillaRegistry) {
        Supplier<Registry> registryGetter = () -> (MutableRegistry)RegistryHelper.getDynamicRegistries().func_230521_a_(vanillaRegistry).get();
        return Codec.STRING.xmap(str -> ((Registry)registryGetter.get()).func_82594_a(new ResourceLocation(str)), item -> ((Registry)registryGetter.get()).func_177774_c(item).toString());
    }

    public static <T> String serializeTagOrRegistryKey(Either<ITag<T>, RegistryKey<T>> obj) {
        return (String)obj.map(tag -> "#" + ConfigHelper.getTagsForObject(obj).func_232973_a_(tag), key -> key.func_240901_a_().toString());
    }

    public static <T extends IForgeRegistryEntry<T>> String serializeTagOrBuiltinObject(IForgeRegistry<T> forgeRegistry, Either<ITag<T>, T> obj) {
        return (String)obj.map(tag -> "#" + ConfigHelper.getTagsForObject(obj).func_232973_a_(tag), regObj -> Optional.ofNullable(forgeRegistry.getKey(regObj)).map(ResourceLocation::toString).orElse(""));
    }

    public static <T> String serializeTagOrRegistryObject(RegistryKey<Registry<T>> registry, Either<ITag<T>, T> obj, DynamicRegistries dynamicRegistries) {
        MutableRegistry reg = dynamicRegistries.func_243612_b(registry);
        return (String)obj.map(tag -> "#" + ConfigHelper.getTagsForObject(obj).func_232973_a_(tag), arg_0 -> ConfigHelper.lambda$serializeTagOrRegistryObject$15((Registry)reg, arg_0));
    }

    public static <T> Either<ITag<T>, RegistryKey<T>> deserializeTagOrRegistryKey(RegistryKey<Registry<T>> registry, String key) {
        if (key.startsWith("#")) {
            ResourceLocation tagID = new ResourceLocation(key.replace("#", ""));
            return Either.left((Object)ConfigHelper.getTagsForRegistry(registry).func_199910_a(tagID));
        }
        RegistryKey biomeKey = RegistryKey.func_240903_a_(registry, (ResourceLocation)new ResourceLocation(key));
        return Either.right((Object)biomeKey);
    }

    public static <T extends IForgeRegistryEntry<T>> Either<ITag<T>, T> deserializeTagOrRegistryObject(String tagOrRegistryObject, RegistryKey<Registry<T>> vanillaRegistry, IForgeRegistry<T> forgeRegistry) {
        if (tagOrRegistryObject.startsWith("#")) {
            ResourceLocation tagID = new ResourceLocation(tagOrRegistryObject.replace("#", ""));
            return Either.left((Object)ConfigHelper.getTagsForRegistry(vanillaRegistry).func_199910_a(tagID));
        }
        ResourceLocation id = new ResourceLocation(tagOrRegistryObject);
        IForgeRegistryEntry obj = forgeRegistry.getValue(id);
        if (obj == null) {
            ColdSweat.LOGGER.error("Error deserializing config: object \"{}\" does not exist", (Object)tagOrRegistryObject);
            return null;
        }
        return Either.right((Object)obj);
    }

    public static Optional<FuelData> findFirstFuelMatching(DynamicHolder<Multimap<Item, FuelData>> predicates, ItemStack stack) {
        for (FuelData predicate : predicates.get().get((Object)stack.func_77973_b())) {
            if (!predicate.test(stack)) continue;
            return Optional.of(predicate);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> Optional<T> parseResource(IResourceManager resourceManager, ResourceLocation location, Codec<T> codec) {
        if (resourceManager == null) {
            return Optional.empty();
        }
        try {
            IResource resource = resourceManager.func_199002_a(location);
            try (InputStreamReader reader = new InputStreamReader(resource.func_199027_b(), StandardCharsets.UTF_8);){
                JsonObject json = JSONUtils.func_212743_a((Reader)reader);
                DataResult result = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
                Optional optional = result.result();
                return optional;
            }
        }
        catch (IOException e) {
            ColdSweat.LOGGER.error((Object)new RuntimeException("Failed to load JSON file: " + location, e));
            return Optional.empty();
        }
    }

    public static String concatStringList(List<String> list) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iter = list.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public static <K, V> V getFirstOrNull(DynamicHolder<Multimap<K, V>> map, K key, Predicate<V> filter) {
        Collection values = map.get().get(key).stream().filter(filter).collect(Collectors.toList());
        if (values.isEmpty()) {
            return null;
        }
        return (V)values.iterator().next();
    }

    private static /* synthetic */ String lambda$serializeTagOrRegistryObject$15(Registry reg, Object regObj) {
        return Optional.ofNullable(reg.func_177774_c(regObj)).map(ResourceLocation::toString).orElse("");
    }
}

