/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class CyclingSlotBackground {
    private static final int ICON_CHANGE_TICK_RATE = 30;
    private static final int ICON_SIZE = 16;
    private static final int ICON_TRANSITION_TICK_DURATION = 4;
    private final int slotIndex;
    private final List<ResourceLocation> icons;
    private int tick;
    private int iconIndex;

    public CyclingSlotBackground(int slotIndex, List<ResourceLocation> icons) {
        this.slotIndex = slotIndex;
        this.icons = icons;
    }

    public void tick() {
        if (!this.icons.isEmpty() && ++this.tick % 30 == 0) {
            this.iconIndex = (this.iconIndex + 1) % this.icons.size();
        }
    }

    public void render(AbstractContainerMenu menu, GuiGraphics graphics, float partialTick, int guiLeft, int guiTop) {
        Slot slot = menu.m_38853_(this.slotIndex);
        if (!this.icons.isEmpty() && !slot.m_6657_()) {
            float transparency;
            boolean shouldTransition = this.icons.size() > 1 && this.tick >= 30;
            float f = transparency = shouldTransition ? this.getIconTransitionTransparency(partialTick) : 1.0f;
            if (transparency < 1.0f) {
                int iconIndex = Math.floorMod(this.iconIndex - 1, this.icons.size());
                this.renderIcon(slot, this.icons.get(iconIndex), 1.0f - transparency, graphics, guiLeft, guiTop);
            }
            this.renderIcon(slot, this.icons.get(this.iconIndex), transparency, graphics, guiLeft, guiTop);
        }
    }

    private void renderIcon(Slot slot, ResourceLocation icon, float alpha, GuiGraphics graphics, int x, int y) {
        RenderSystem.enableBlend();
        graphics.m_280246_(1.0f, 1.0f, 1.0f, alpha);
        graphics.m_280163_(icon, x + slot.f_40220_, y + slot.f_40221_, 0.0f, 0.0f, 16, 16, 16, 16);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
    }

    private float getIconTransitionTransparency(float partialTick) {
        float $$1 = (float)(this.tick % 30) + partialTick;
        return Math.min($$1, 4.0f) / 4.0f;
    }
}

