/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.fluid;

import com.momosoftworks.coldsweat.core.init.BlockInit;
import com.momosoftworks.coldsweat.core.init.FluidInit;
import com.momosoftworks.coldsweat.core.init.ItemInit;
import com.momosoftworks.coldsweat.util.registries.ModGameRules;
import com.momosoftworks.coldsweat.util.registries.ModSounds;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public abstract class SlushFluid
extends ForgeFlowingFluid
implements IClientFluidTypeExtensions {
    protected SlushFluid(ForgeFlowingFluid.Properties properties) {
        super(properties);
    }

    public static BlockBehaviour.Properties getBlockProperties() {
        return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283828_).m_280170_().m_60910_().m_60977_().m_60978_(100.0f).m_278166_(PushReaction.DESTROY).m_222994_().m_278788_().m_60918_(SoundType.f_279557_);
    }

    public static FluidType.Properties getFluidProperties() {
        return FluidType.Properties.create().descriptionId("block.cold_sweat.slush").canSwim(false).fallDistanceModifier(0.2f).sound(SoundActions.BUCKET_FILL, ModSounds.BUCKET_FILL_SLUSH).sound(SoundActions.BUCKET_EMPTY, ModSounds.BUCKET_EMPTY_SLUSH).supportsBoating(true).canExtinguish(true).canHydrate(true);
    }

    public static ForgeFlowingFluid.Properties getForgeProperties() {
        return new ForgeFlowingFluid.Properties(FluidInit.SLUSH_TYPE, FluidInit.SLUSH, FluidInit.FLOWING_SLUSH).slopeFindDistance(2).levelDecreasePerBlock(2).tickRate(30).explosionResistance(100.0f).bucket(ItemInit.SLUSH_BUCKET).block(BlockInit.SLUSH);
    }

    public boolean canConvertToSource(FluidState state, Level level, BlockPos pos) {
        return level.m_46469_().m_46207_(ModGameRules.RULE_SLUSH_SOURCE_CONVERSION);
    }

    protected void m_6364_(LevelAccessor level, BlockPos pos, BlockState blockState, Direction direction, FluidState fluidState) {
        FluidState targetFluidState = level.m_6425_(pos);
        if (targetFluidState.m_205070_(FluidTags.f_13131_)) {
            BlockState resultBlock = Blocks.f_50127_.m_49966_();
            if (blockState.m_60734_() instanceof LiquidBlock) {
                level.m_7731_(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)pos, (BlockPos)pos, (BlockState)resultBlock), 3);
            }
            SlushFluid.fizz(level, pos);
            return;
        }
        super.m_6364_(level, pos, blockState, direction, fluidState);
    }

    public static void fizz(LevelAccessor ilevel, BlockPos pos) {
        if (ilevel instanceof Level) {
            Level level = (Level)ilevel;
            Vec3 centerPos = pos.m_252807_();
            BlockParticleOption particleData = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50127_.m_49966_());
            WorldHelper.spawnParticleBatch(level, (ParticleOptions)particleData, centerPos.f_82479_, centerPos.f_82480_, centerPos.f_82481_, 0.6, 0.6, 0.6, 15.0, 0.1);
            level.m_247517_(null, pos, SoundEvents.f_12474_, SoundSource.BLOCKS);
        }
    }

    public static class Source
    extends SlushFluid {
        public Source(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        public int m_7430_(FluidState state) {
            return 8;
        }

        public boolean m_7444_(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends SlushFluid {
        public Flowing(ForgeFlowingFluid.Properties properties) {
            super(properties);
            this.m_76142_((FluidState)((FluidState)this.m_76144_().m_61090_()).m_61124_((Property)f_75948_, (Comparable)Integer.valueOf(7)));
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }
    }
}

