/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.advancement.trigger;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class ArmorInsulatedTrigger
extends SimpleCriterionTrigger<Instance> {
    static final ResourceLocation ID = new ResourceLocation("cold_sweat", "armor_insulated");

    protected Instance createInstance(JsonObject json, ContextAwarePredicate player, DeserializationContext context) {
        ItemPredicate armorStack = ItemPredicate.m_45051_((JsonElement)json.get("armor_item"));
        ItemPredicate[] insulStack = ItemPredicate.m_45055_((JsonElement)json.get("insulation_item"));
        return new Instance(player, armorStack, insulStack);
    }

    public ResourceLocation m_7295_() {
        return ID;
    }

    public void trigger(ServerPlayer player, ItemStack fuelStack, ItemStack lampStack) {
        this.m_66234_(player, triggerInstance -> triggerInstance.matches(fuelStack, lampStack));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final ItemPredicate armorStack;
        private final ItemPredicate[] insulStack;

        public Instance(ContextAwarePredicate player, ItemPredicate armorStack, ItemPredicate[] insulStack) {
            super(ID, player);
            this.armorStack = armorStack;
            this.insulStack = insulStack;
        }

        public boolean matches(ItemStack fuelStack, ItemStack lampStack) {
            return this.armorStack.m_45049_(fuelStack) && (this.insulStack.length == 0 || Arrays.stream(this.insulStack).anyMatch(predicate -> predicate.m_45049_(lampStack)));
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject obj = super.m_7683_(context);
            obj.add("armor_item", this.armorStack.m_45048_());
            JsonArray jsonarray = new JsonArray();
            for (ItemPredicate itemPredicate : this.insulStack) {
                jsonarray.add(itemPredicate.m_45048_());
            }
            obj.add("insulation_item", (JsonElement)jsonarray);
            return obj;
        }
    }
}

