/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.advancement.trigger;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import java.util.List;

public class TriggerHelper {
    public static Either<Double, Pair<Double, Double>> getTempValueOrRange(JsonObject entry) {
        double above;
        double below;
        block11: {
            if (entry.has("value")) {
                double value = entry.get("value").getAsDouble();
                return Either.left((Object)value);
            }
            JsonObject range = entry.getAsJsonObject("range");
            below = Double.POSITIVE_INFINITY;
            above = Double.NEGATIVE_INFINITY;
            if (range != null) {
                String builtinValue;
                block10: {
                    if (range.has("below")) {
                        try {
                            below = range.get("below").getAsDouble();
                        }
                        catch (Exception e) {
                            builtinValue = range.get("below").getAsString();
                            if (builtinValue.equals("max_habitable")) {
                                below = ConfigSettings.MAX_TEMP.get();
                            }
                            if (!builtinValue.equals("min_habitable")) break block10;
                            below = ConfigSettings.MIN_TEMP.get();
                        }
                    }
                }
                if (range.has("above")) {
                    try {
                        above = range.get("above").getAsDouble();
                    }
                    catch (Exception e) {
                        builtinValue = range.get("above").getAsString();
                        if (builtinValue.equals("max_habitable")) {
                            above = ConfigSettings.MAX_TEMP.get();
                        }
                        if (!builtinValue.equals("min_habitable")) break block11;
                        above = ConfigSettings.MIN_TEMP.get();
                    }
                }
            }
        }
        return Either.right((Object)new Pair((Object)below, (Object)above));
    }

    public static JsonArray serializeConditions(List<TempCondition> conditions) {
        JsonArray values = new JsonArray();
        for (TempCondition condition : conditions) {
            double above = condition.above();
            double below = condition.below();
            JsonObject value = new JsonObject();
            value.addProperty("type", condition.trait().m_7912_());
            if (above == below) {
                value.addProperty("value", (Number)above);
                continue;
            }
            JsonObject range = new JsonObject();
            range.addProperty("below", (Number)below);
            range.addProperty("above", (Number)above);
            value.add("range", (JsonElement)range);
            values.add((JsonElement)value);
        }
        return values;
    }

    public record TempCondition(Temperature.Trait trait, double below, double above) {
        public boolean matches(double value) {
            return this.below > this.above ? value >= this.above && value <= this.below : value >= this.above || value <= this.below;
        }
    }
}

