/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.impl.RequirementHolder;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FoodData
extends ConfigData
implements RequirementHolder {
    final NegatableList<ItemRequirement> item;
    final Double temperature;
    final int duration;
    final int stackLimit;
    final NegatableList<EntityRequirement> entityRequirement;
    public static final Codec<FoodData> CODEC = FoodData.createCodec(RecordCodecBuilder.mapCodec(instance -> instance.group((App)NegatableList.codec(ItemRequirement.CODEC).optionalFieldOf("item", new NegatableList()).forGetter(FoodData::item), (App)Codec.DOUBLE.fieldOf("temperature").forGetter(FoodData::temperature), (App)Codec.INT.optionalFieldOf("duration", (Object)0).forGetter(FoodData::duration), (App)Codec.INT.optionalFieldOf("stack_limit", (Object)1).forGetter(data -> data.stackLimit), (App)NegatableList.codec(EntityRequirement.getCodec()).optionalFieldOf("entity", new NegatableList()).forGetter(FoodData::entityRequirement)).apply((Applicative)instance, FoodData::new)));

    public FoodData(NegatableList<ItemRequirement> item, Double temperature, int duration, int stackLimit, NegatableList<EntityRequirement> entityRequirement, NegatableList<String> requiredMods) {
        super(requiredMods);
        this.temperature = temperature;
        this.item = item;
        this.duration = duration;
        this.stackLimit = stackLimit;
        this.entityRequirement = entityRequirement;
    }

    public FoodData(NegatableList<ItemRequirement> item, Double temperature, int duration, int stackLimit, NegatableList<EntityRequirement> entityRequirement) {
        this(item, temperature, duration, stackLimit, entityRequirement, new NegatableList<String>());
    }

    public NegatableList<ItemRequirement> item() {
        return this.item;
    }

    public Double temperature() {
        return this.temperature;
    }

    public int duration() {
        return this.duration;
    }

    public int stackLimit() {
        return this.stackLimit;
    }

    public NegatableList<EntityRequirement> entityRequirement() {
        return this.entityRequirement;
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.item.test((T req) -> req.test(stack, true));
    }

    @Override
    public boolean test(Entity entity) {
        return this.entityRequirement.test((T req) -> req.test(entity));
    }

    @Nullable
    public static FoodData fromToml(List<?> entry) {
        if (entry.size() < 2) {
            ColdSweat.LOGGER.error("Error parsing food config: not enough arguments");
            return null;
        }
        NegatableList<Either<TagKey<Item>, Item>> items = ConfigHelper.getItems((String)entry.get(0));
        if (items.isEmpty()) {
            return null;
        }
        double temperature = ((Number)entry.get(1)).doubleValue();
        NbtRequirement nbtRequirement = entry.size() > 2 ? new NbtRequirement(NBTHelper.parseCompoundNbt((String)entry.get(2))) : new NbtRequirement(new CompoundTag());
        int duration = entry.size() > 3 ? ((Number)entry.get(3)).intValue() : 0;
        int stackLimit = entry.size() > 4 ? (Integer)entry.get(4) : 1;
        ItemRequirement itemRequirement = new ItemRequirement(items, nbtRequirement);
        FoodData result = new FoodData(new NegatableList<ItemRequirement>(itemRequirement), temperature, duration, stackLimit, new NegatableList<EntityRequirement>());
        result.setConfigType(ConfigData.Type.TOML);
        return result;
    }

    public Codec<FoodData> getCodec() {
        return CODEC;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FoodData that = (FoodData)obj;
        return super.equals(obj) && this.item.equals(that.item) && this.temperature.equals(that.temperature) && this.duration == that.duration && this.entityRequirement.equals(that.entityRequirement);
    }
}

