/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.impl.RequirementHolder;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class MountData
extends ConfigData
implements RequirementHolder {
    final NegatableList<EntityRequirement> entity;
    final NegatableList<EntityRequirement> rider;
    final double coldInsulation;
    final double heatInsulation;
    final Map<ResourceLocation, Double> modifierImmunities;
    public static Codec<MountData> CODEC = MountData.createCodec(RecordCodecBuilder.mapCodec(instance -> instance.group((App)NegatableList.codec(EntityRequirement.getCodec()).fieldOf("entity").forGetter(MountData::entity), (App)NegatableList.codec(EntityRequirement.getCodec()).optionalFieldOf("rider", new NegatableList()).forGetter(MountData::rider), (App)Codec.DOUBLE.optionalFieldOf("cold_insulation", (Object)0.0).forGetter(MountData::coldInsulation), (App)Codec.DOUBLE.optionalFieldOf("heat_insulation", (Object)0.0).forGetter(MountData::heatInsulation), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, (Codec)Codec.DOUBLE).optionalFieldOf("immune_temp_modifiers", new HashMap()).forGetter(MountData::modifierImmunities)).apply((Applicative)instance, MountData::new)));

    public MountData(NegatableList<EntityRequirement> entity, NegatableList<EntityRequirement> rider, double coldInsulation, double heatInsulation, Map<ResourceLocation, Double> modifierImmunities, NegatableList<String> requiredMods) {
        super(requiredMods);
        this.entity = entity;
        this.rider = rider;
        this.coldInsulation = coldInsulation;
        this.heatInsulation = heatInsulation;
        this.modifierImmunities = modifierImmunities;
    }

    public MountData(NegatableList<EntityRequirement> entity, NegatableList<EntityRequirement> rider, double coldInsulation, double heatInsulation, Map<ResourceLocation, Double> modifierImmunities) {
        this(entity, rider, coldInsulation, heatInsulation, modifierImmunities, new NegatableList<String>());
    }

    public NegatableList<EntityRequirement> entity() {
        return this.entity;
    }

    public NegatableList<EntityRequirement> rider() {
        return this.rider;
    }

    public double coldInsulation() {
        return this.coldInsulation;
    }

    public double heatInsulation() {
        return this.heatInsulation;
    }

    public Map<ResourceLocation, Double> modifierImmunities() {
        return this.modifierImmunities;
    }

    @Nullable
    public static MountData fromToml(List<?> entry) {
        if (entry.size() < 2) {
            ColdSweat.LOGGER.error("Error parsing insulating mount config: not enough arguments");
            return null;
        }
        NegatableList<Either<TagKey<EntityType<?>>, EntityType<?>>> entities = ConfigHelper.getEntityTypes((String)entry.get(0));
        if (entities.isEmpty()) {
            return null;
        }
        double coldInsul = ((Number)entry.get(1)).doubleValue();
        double hotInsul = entry.size() < 3 ? coldInsul : ((Number)entry.get(2)).doubleValue();
        MountData result = new MountData(new NegatableList<EntityRequirement>(new EntityRequirement(entities)), new NegatableList<EntityRequirement>(), coldInsul, hotInsul, Map.of());
        result.setConfigType(ConfigData.Type.TOML);
        return result;
    }

    @Override
    public boolean test(Entity entity) {
        return this.entity.test((T rq) -> rq.test(entity));
    }

    public Codec<MountData> getCodec() {
        return CODEC;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MountData that = (MountData)obj;
        return super.equals(obj) && this.entity.equals(that.entity) && this.rider.equals(that.rider) && Double.compare(that.coldInsulation, this.coldInsulation) == 0 && Double.compare(that.heatInsulation, this.heatInsulation) == 0;
    }
}

