/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.requirement.LocationRequirement;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.OptionalHolder;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class SpawnBiomeData
extends ConfigData {
    final NegatableList<Either<TagKey<Biome>, OptionalHolder<Biome>>> biomes;
    final NegatableList<Either<TagKey<EntityType<?>>, EntityType<?>>> entities;
    final MobCategory category;
    final int weight;
    final IntegerBounds count;
    final NegatableList<LocationRequirement> location;
    public static final Codec<SpawnBiomeData> CODEC = SpawnBiomeData.createCodec(RecordCodecBuilder.mapCodec(instance -> instance.group((App)NegatableList.listCodec(ConfigHelper.tagOrHolderCodec(Registries.f_256952_)).fieldOf("biomes").forGetter(SpawnBiomeData::biomes), (App)NegatableList.listCodec(ConfigHelper.tagOrBuiltinCodec(Registries.f_256939_, ForgeRegistries.ENTITY_TYPES)).fieldOf("entities").forGetter(SpawnBiomeData::entities), (App)MobCategory.f_21584_.fieldOf("category").forGetter(SpawnBiomeData::category), (App)Codec.INT.fieldOf("weight").forGetter(SpawnBiomeData::weight), (App)IntegerBounds.CODEC.optionalFieldOf("count", (Object)IntegerBounds.NONE).forGetter(SpawnBiomeData::count), (App)NegatableList.codec(LocationRequirement.CODEC).optionalFieldOf("location", new NegatableList()).forGetter(SpawnBiomeData::location)).apply((Applicative)instance, SpawnBiomeData::new)));

    public SpawnBiomeData(NegatableList<Either<TagKey<Biome>, OptionalHolder<Biome>>> biomes, NegatableList<Either<TagKey<EntityType<?>>, EntityType<?>>> entities, MobCategory category, int weight, IntegerBounds count, NegatableList<LocationRequirement> location, NegatableList<String> requiredMods) {
        super(requiredMods);
        this.biomes = biomes;
        this.entities = entities;
        this.category = category;
        this.weight = weight;
        this.count = count;
        this.location = location;
    }

    public SpawnBiomeData(NegatableList<Either<TagKey<Biome>, OptionalHolder<Biome>>> biomes, NegatableList<Either<TagKey<EntityType<?>>, EntityType<?>>> entities, MobCategory category, int weight, IntegerBounds count, NegatableList<LocationRequirement> location) {
        this(biomes, entities, category, weight, count, location, new NegatableList<String>());
    }

    public SpawnBiomeData(Collection<OptionalHolder<Biome>> biomes, MobCategory category, int weight, Collection<EntityType<?>> entities, IntegerBounds count, NegatableList<LocationRequirement> location) {
        this(new NegatableList<Either<TagKey<Biome>, OptionalHolder<Biome>>>(biomes.stream().map(Either::right).toList()), new NegatableList(entities.stream().map(Either::right).toList()), category, weight, count, location);
    }

    public NegatableList<Either<TagKey<Biome>, OptionalHolder<Biome>>> biomes() {
        return this.biomes;
    }

    public MobCategory category() {
        return this.category;
    }

    public int weight() {
        return this.weight;
    }

    public NegatableList<Either<TagKey<EntityType<?>>, EntityType<?>>> entities() {
        return this.entities;
    }

    public IntegerBounds count() {
        return this.count;
    }

    public NegatableList<LocationRequirement> location() {
        return this.location;
    }

    @Nullable
    public static SpawnBiomeData fromToml(List<?> entry, EntityType<?> entityType, RegistryAccess registryAccess) {
        if (entry.size() < 2) {
            ColdSweat.LOGGER.error("Error parsing entity spawn biome config: not enough arguments");
            return null;
        }
        NegatableList<Either<TagKey<Biome>, OptionalHolder<Biome>>> biomes = ConfigHelper.parseRegistryItems(Registries.f_256952_, registryAccess, (String)entry.get(0));
        if (biomes.isEmpty()) {
            return null;
        }
        SpawnBiomeData result = new SpawnBiomeData(biomes, new NegatableList(Either.right(entityType)), MobCategory.CREATURE, ((Number)entry.get(1)).intValue(), new IntegerBounds(1, 1), new NegatableList<LocationRequirement>());
        result.setConfigType(ConfigData.Type.TOML);
        return result;
    }

    public Codec<SpawnBiomeData> getCodec() {
        return CODEC;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SpawnBiomeData that = (SpawnBiomeData)obj;
        return this.biomes.equals(that.biomes) && this.category == that.category && this.weight == that.weight && this.entities.equals(that.entities) && this.count.equals(that.count) && this.location.equals(that.location);
    }
}

