/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.insulation.slot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.util.ExtraCodecs;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.EnumHelper;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;

public abstract class ScalingFormula {
    Type scaling;

    public static Codec<ScalingFormula> getCodec() {
        return Codec.either(Static.CODEC, Dynamic.CODEC).xmap(either -> (ScalingFormula)either.map(left -> left, right -> right), scaling -> scaling instanceof Static ? Either.left((Object)((Static)scaling)) : Either.right((Object)((Dynamic)scaling)));
    }

    protected ScalingFormula(Type scaling) {
        this.scaling = scaling;
    }

    public abstract int getSlots(EquipmentSlot var1, ItemStack var2);

    public abstract List<? extends Number> getValues();

    public Type getType() {
        return this.scaling;
    }

    public static class Static
    extends ScalingFormula {
        public static final Codec<Static> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("head").forGetter(s -> s.slots.getOrDefault(EquipmentSlot.HEAD, 0)), (App)Codec.INT.fieldOf("body").forGetter(s -> s.slots.getOrDefault(EquipmentSlot.CHEST, 0)), (App)Codec.INT.fieldOf("legs").forGetter(s -> s.slots.getOrDefault(EquipmentSlot.LEGS, 0)), (App)Codec.INT.fieldOf("feet").forGetter(s -> s.slots.getOrDefault(EquipmentSlot.FEET, 0))).apply((Applicative)instance, Static::new));
        Map<EquipmentSlot, Integer> slots = new EnumMap<EquipmentSlot, Integer>(EquipmentSlot.class);

        public Static(int head, int body, int legs, int feet) {
            super(Type.STATIC);
            this.slots.put(EquipmentSlot.HEAD, head);
            this.slots.put(EquipmentSlot.CHEST, body);
            this.slots.put(EquipmentSlot.LEGS, legs);
            this.slots.put(EquipmentSlot.FEET, feet);
        }

        @Override
        public int getSlots(EquipmentSlot slot, ItemStack stack) {
            return this.slots.getOrDefault(slot, 0);
        }

        @Override
        public List<? extends Number> getValues() {
            return List.of(this.slots.get(EquipmentSlot.HEAD), this.slots.get(EquipmentSlot.CHEST), this.slots.get(EquipmentSlot.LEGS), this.slots.get(EquipmentSlot.FEET));
        }
    }

    public static class Dynamic
    extends ScalingFormula {
        public static final Codec<Dynamic> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Type.CODEC.fieldOf("scaling").forGetter(ScalingFormula::getType), (App)Codec.DOUBLE.fieldOf("factor").forGetter(s -> s.factor), (App)Codec.DOUBLE.fieldOf("max").forGetter(s -> s.max)).apply((Applicative)instance, Dynamic::new));
        double factor;
        double max;

        public Dynamic(Type scaling, double factor, double max) {
            super(scaling);
            this.factor = factor;
            this.max = max;
        }

        @Override
        public int getSlots(EquipmentSlot slot, ItemStack stack) {
            double protection = stack.getAttributeModifiers().modifiers().stream().filter(entry -> entry.attribute() == Attributes.ARMOR).findFirst().map(entry -> entry.modifier().amount()).orElse(0.0);
            return switch (this.scaling.ordinal()) {
                case 1 -> (int)CSMath.clamp(Math.floor(protection * this.factor), 0.0, this.max);
                case 2 -> (int)CSMath.clamp(Math.floor(Math.pow(protection, this.factor)), 0.0, this.max);
                case 3 -> (int)CSMath.clamp(Math.floor(Math.sqrt(protection) * this.factor), 0.0, this.max);
                default -> 0;
            };
        }

        @Override
        public List<? extends Number> getValues() {
            return List.of(Double.valueOf(this.factor), Double.valueOf(this.max));
        }
    }

    public static enum Type implements StringRepresentable
    {
        STATIC("static"),
        LINEAR("linear"),
        EXPONENTIAL("exponential"),
        LOGARITHMIC("logarithmic");

        final String name;
        public static final Codec<Type> CODEC;

        private Type(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public static Type byName(String name) {
            return (Type)EnumHelper.byName((Enum[])Type.values(), (String)name);
        }

        static {
            CODEC = ExtraCodecs.enumIgnoreCase((Enum[])Type.values());
        }
    }
}

