/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemTempData;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class InventoryItemsTempModifier
extends TempModifier {
    private final Map<Temperature.Trait, Double> effectsPerTrait = new EnumMap<Temperature.Trait, Double>(Temperature.Trait.class);

    public InventoryItemsTempModifier(double temp) {
        this.getNBT().putDouble("Effect", temp);
    }

    public InventoryItemsTempModifier() {
        this(0.0);
    }

    @Override
    protected Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        return temp -> temp + this.effectsPerTrait.getOrDefault((Object)trait, 0.0);
    }

    @Override
    public void tick(LivingEntity entity) {
        this.effectsPerTrait.clear();
        HashMap effectsPerItemTemp = new HashMap();
        EntityTempManager.getItemTemperaturesOnEntity(entity).forEach((stack, data) -> InventoryItemsTempModifier.addItemTemp(entity, stack, data, effectsPerItemTemp));
        for (Map.Entry entry : effectsPerItemTemp.entrySet()) {
            Temperature.Trait dataTrait = ((ItemTempData)entry.getKey()).trait();
            double temp = (Double)entry.getValue();
            this.effectsPerTrait.put(dataTrait, this.effectsPerTrait.getOrDefault((Object)dataTrait, 0.0) + temp);
        }
    }

    private static void addItemTemp(LivingEntity entity, ItemStack stack, ItemTempData itemData, Map<ItemTempData, Double> effectsPerItemTemp) {
        double temp = itemData.temperature() * (double)stack.getCount();
        double currentEffect = effectsPerItemTemp.getOrDefault(itemData, 0.0);
        double newEffect = currentEffect + temp;
        newEffect = temp > 0.0 ? Math.min(itemData.maxEffect(), newEffect) : Math.max(-itemData.maxEffect(), newEffect);
        newEffect = Math.max(itemData.minTemp(), Math.min(itemData.maxTemp(), newEffect));
        effectsPerItemTemp.put(itemData, newEffect);
    }
}

