/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier.compat;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.SeasonalTempData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.function.Function;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;

public class SereneSeasonsTempModifier
extends TempModifier {
    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        if (ModConfig.seasons.whitelistedDimensions.contains(entity.level().dimension().location().toString())) {
            ISeasonState season = SeasonHelper.getSeasonState((Level)entity.level());
            SeasonalTempData springTemps = ConfigSettings.SPRING_TEMPS.get();
            SeasonalTempData summerTemps = ConfigSettings.SUMMER_TEMPS.get();
            SeasonalTempData autumnTemps = ConfigSettings.AUTUMN_TEMPS.get();
            SeasonalTempData winterTemps = ConfigSettings.WINTER_TEMPS.get();
            Pair startEndTemps = switch (season.getSubSeason()) {
                default -> throw new MatchException(null, null);
                case Season.SubSeason.EARLY_AUTUMN -> Pair.of((Object)autumnTemps.getStartTemp(), (Object)autumnTemps.getMiddleTemp());
                case Season.SubSeason.MID_AUTUMN -> Pair.of((Object)autumnTemps.getMiddleTemp(), (Object)autumnTemps.getEndTemp());
                case Season.SubSeason.LATE_AUTUMN -> Pair.of((Object)autumnTemps.getEndTemp(), (Object)winterTemps.getStartTemp());
                case Season.SubSeason.EARLY_WINTER -> Pair.of((Object)winterTemps.getStartTemp(), (Object)winterTemps.getMiddleTemp());
                case Season.SubSeason.MID_WINTER -> Pair.of((Object)winterTemps.getMiddleTemp(), (Object)winterTemps.getEndTemp());
                case Season.SubSeason.LATE_WINTER -> Pair.of((Object)winterTemps.getEndTemp(), (Object)springTemps.getStartTemp());
                case Season.SubSeason.EARLY_SPRING -> Pair.of((Object)springTemps.getStartTemp(), (Object)springTemps.getMiddleTemp());
                case Season.SubSeason.MID_SPRING -> Pair.of((Object)springTemps.getMiddleTemp(), (Object)springTemps.getEndTemp());
                case Season.SubSeason.LATE_SPRING -> Pair.of((Object)springTemps.getEndTemp(), (Object)summerTemps.getStartTemp());
                case Season.SubSeason.EARLY_SUMMER -> Pair.of((Object)summerTemps.getStartTemp(), (Object)summerTemps.getMiddleTemp());
                case Season.SubSeason.MID_SUMMER -> Pair.of((Object)summerTemps.getMiddleTemp(), (Object)summerTemps.getEndTemp());
                case Season.SubSeason.LATE_SUMMER -> Pair.of((Object)summerTemps.getEndTemp(), (Object)autumnTemps.getStartTemp());
            };
            double startValue = (Double)startEndTemps.getFirst();
            double endValue = (Double)startEndTemps.getSecond();
            return temp -> temp + (double)((float)CSMath.blend(startValue, endValue, (double)(season.getDay() % (season.getSubSeasonDuration() / season.getDayDuration())), 0.0, 8.0));
        }
        return temp -> temp;
    }
}

