/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.util;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.util.serialization.EnumHelper;
import java.util.function.Predicate;
import net.minecraft.util.StringRepresentable;

public record Placement(Mode mode, Order order, Predicate<TempModifier> predicate) {
    public static final Placement AFTER_LAST = Placement.of(Mode.AFTER, Order.LAST, (TempModifier mod) -> true);
    public static final Placement BEFORE_FIRST = Placement.of(Mode.BEFORE, Order.FIRST, (TempModifier mod) -> true);

    public static Placement of(Mode mode, Order order, Predicate<TempModifier> predicate) {
        return new Placement(mode, order, predicate);
    }

    public static Placement of(Mode mode, Order order, Class<? extends TempModifier> clazz) {
        return new Placement(mode, order, clazz::isInstance);
    }

    public static enum Mode implements StringRepresentable
    {
        BEFORE("before"),
        AFTER("after"),
        REPLACE("replace"),
        REPLACE_OR_ADD("replace_or_add");

        private final String name;

        private Mode(String name) {
            this.name = name;
        }

        public boolean isReplacing() {
            return this == REPLACE || this == REPLACE_OR_ADD;
        }

        public String getSerializedName() {
            return this.name;
        }

        public static Mode byName(String name) {
            return (Mode)EnumHelper.byName((Enum[])Mode.values(), (String)name);
        }
    }

    public static enum Order implements StringRepresentable
    {
        FIRST("first"),
        LAST("last");

        private final String name;

        private Order(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public static Order byName(String name) {
            return (Order)EnumHelper.byName((Enum[])Order.values(), (String)name);
        }
    }

    public static enum Duplicates implements StringRepresentable
    {
        ALLOW("allow"),
        BY_CLASS("by_class"),
        EXACT("exact");

        private final String name;

        private Duplicates(String name) {
            this.name = name;
        }

        public boolean check(TempModifier modA, TempModifier modB) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> false;
                case 1 -> modA.getClass().equals(modB.getClass());
                case 2 -> modA.equals(modB);
            };
        }

        public String getSerializedName() {
            return this.name;
        }

        public static Duplicates byName(String name) {
            return (Duplicates)EnumHelper.byName((Enum[])Duplicates.values(), (String)name);
        }
    }
}

