/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer.animation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.momosoftworks.coldsweat.client.renderer.animation.Animation;
import com.momosoftworks.coldsweat.client.renderer.animation.Keyframe;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class AnimationBatch {
    Map<String, Animation> animations = new HashMap<String, Animation>();

    public AnimationBatch(Animation ... animations) {
        for (Animation animation : animations) {
            this.animations.put(animation.partName, animation);
        }
    }

    public void addAnimation(String name, Animation animation) {
        this.animations.put(name, animation);
    }

    public Animation getAnimation(String name) {
        return this.animations.computeIfAbsent(name, k -> new Animation(name, 0.0f, new ArrayList<Keyframe>(), new ArrayList<Keyframe>()));
    }

    public void animateAll(Map<String, ModelPart> parts, float animationTime, boolean offset) {
        parts.forEach((name, part) -> this.getAnimation((String)name).setPositions(animationTime, (ModelPart)part, offset).setRotations(animationTime, (ModelPart)part, offset));
    }

    public void animate(String name, ModelPart part, float animationTime, boolean offset) {
        this.getAnimation(name).setPositions(animationTime, part, offset).setRotations(animationTime, part, offset);
    }

    public static AnimationBatch loadFromFile(ResourceLocation path) {
        AnimationBatch batch = new AnimationBatch(new Animation[0]);
        try {
            InputStream inputStream = ((Resource)Minecraft.getInstance().getResourceManager().getResource(path).orElseThrow()).open();
            JsonObject obj = JsonParser.parseReader((Reader)new InputStreamReader(inputStream)).getAsJsonObject();
            JsonObject animations = obj.getAsJsonObject("animations");
            for (Map.Entry animation : animations.entrySet()) {
                JsonObject animationObj = ((JsonElement)animation.getValue()).getAsJsonObject();
                JsonObject bones = animationObj.getAsJsonObject("bones").getAsJsonObject();
                for (Map.Entry boneEntry : bones.entrySet()) {
                    String boneName = (String)boneEntry.getKey();
                    JsonObject bone = ((JsonElement)boneEntry.getValue()).getAsJsonObject();
                    ArrayList<Keyframe> posFrames = new ArrayList<Keyframe>();
                    if (bone.has("position")) {
                        JsonObject pos = bone.getAsJsonObject("position");
                        if (pos.has("vector")) {
                            JsonArray vector = pos.getAsJsonArray("vector");
                            float x = AnimationBatch.floatFromJSON(vector.get(0));
                            float y = AnimationBatch.floatFromJSON(vector.get(1));
                            float z = AnimationBatch.floatFromJSON(vector.get(2));
                            posFrames.add(new Keyframe(0.0f, x, y, z));
                        } else {
                            for (Map.Entry posEntry : bone.getAsJsonObject("position").entrySet()) {
                                float timestamp = Float.parseFloat((String)posEntry.getKey());
                                JsonObject position = ((JsonElement)posEntry.getValue()).getAsJsonObject();
                                JsonArray vector = position.getAsJsonArray("vector");
                                float x = AnimationBatch.floatFromJSON(vector.get(0));
                                float y = AnimationBatch.floatFromJSON(vector.get(1));
                                float z = AnimationBatch.floatFromJSON(vector.get(2));
                                posFrames.add(new Keyframe(timestamp, x, y, z));
                            }
                        }
                    }
                    ArrayList<Keyframe> rotFrames = new ArrayList<Keyframe>();
                    if (bone.has("rotation")) {
                        JsonObject rot = bone.getAsJsonObject("rotation");
                        if (rot.has("vector")) {
                            JsonArray vector = rot.getAsJsonArray("vector");
                            float x = AnimationBatch.floatFromJSON(vector.get(0));
                            float y = AnimationBatch.floatFromJSON(vector.get(1));
                            float z = AnimationBatch.floatFromJSON(vector.get(2));
                            rotFrames.add(new Keyframe(0.0f, x, y, z));
                        } else {
                            for (Map.Entry rotEntry : bone.getAsJsonObject("rotation").entrySet()) {
                                float timestamp = Float.parseFloat((String)rotEntry.getKey());
                                JsonObject rotation = ((JsonElement)rotEntry.getValue()).getAsJsonObject();
                                JsonArray vector = rotation.getAsJsonArray("vector");
                                float x = AnimationBatch.floatFromJSON(vector.get(0));
                                float y = AnimationBatch.floatFromJSON(vector.get(1));
                                float z = AnimationBatch.floatFromJSON(vector.get(2));
                                rotFrames.add(new Keyframe(timestamp, x, y, z));
                            }
                        }
                    }
                    Animation anim = new Animation(boneName, animationObj.get("animation_length").getAsFloat(), posFrames, rotFrames);
                    batch.addAnimation(boneName, anim);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return batch;
    }

    static float floatFromJSON(JsonElement element) {
        try {
            return element.getAsFloat();
        }
        catch (Exception e) {
            String str = element.getAsString();
            if (str.equals("-")) {
                return 0.0f;
            }
            return Float.parseFloat(element.getAsString().replaceAll("[^\\d-.]", ""));
        }
    }

    public String toString() {
        return this.animations.toString();
    }
}

