/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.common.capability.insulation.ItemInsulationCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModItemComponents;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemInsulationSlotsData;
import com.momosoftworks.coldsweat.util.item.ItemStackHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;

public class ItemInsulationManager {
    public static Optional<ItemInsulationCap> getInsulationCap(ItemStack stack) {
        if (ItemInsulationManager.isInsulatable(stack) && !stack.has(ModItemComponents.ARMOR_INSULATION)) {
            stack.set(ModItemComponents.ARMOR_INSULATION, (Object)new ItemInsulationCap());
        }
        return Optional.ofNullable((ItemInsulationCap)stack.get(ModItemComponents.ARMOR_INSULATION));
    }

    public static int getInsulationSlots(ItemStack stack) {
        if (ItemInsulationManager.isInsulatable(stack)) {
            Item item = stack.getItem();
            Optional slotOverride = ConfigSettings.INSULATION_SLOT_OVERRIDES.get().get((Object)item).stream().findFirst();
            if (slotOverride.isPresent() && ((ItemInsulationSlotsData)slotOverride.get()).test(stack)) {
                return ((ItemInsulationSlotsData)slotOverride.get()).slots();
            }
            return ConfigSettings.INSULATION_SLOTS.get().getSlots(((Equipable)item).getEquipmentSlot(), stack);
        }
        return 0;
    }

    public static boolean isInsulatable(ItemStack stack) {
        Equipable equipable;
        Item item = stack.getItem();
        return item instanceof Equipable && (equipable = (Equipable)item).getEquipmentSlot().isArmor() && !ConfigSettings.INSULATION_BLACKLIST.get().contains(stack.getItem()) && ItemInsulationManager.getInsulatorInsulation(stack).isEmpty();
    }

    public static int getSlotsFilled(Collection<InsulatorData> insulators) {
        int slots = 0;
        for (InsulatorData data : insulators) {
            if (data.fillSlots()) {
                slots += Insulation.splitList(data.insulation()).size();
                continue;
            }
            ++slots;
        }
        return slots;
    }

    public static Multimap<Item, InsulatorData> getInsulatorsForSlotType(Insulation.Slot slot) {
        return switch (slot) {
            default -> throw new MatchException(null, null);
            case Insulation.Slot.ITEM -> ConfigSettings.INSULATION_ITEMS.get();
            case Insulation.Slot.ARMOR -> ConfigSettings.INSULATING_ARMORS.get();
            case Insulation.Slot.CURIO -> ConfigSettings.INSULATING_CURIOS.get();
        };
    }

    public static List<Insulation> getInsulatorInsulation(ItemStack stack) {
        if (!ConfigSettings.INSULATION_ITEMS.get().containsKey((Object)stack.getItem())) {
            return ImmutableList.of();
        }
        return ConfigSettings.INSULATION_ITEMS.get().get((Object)stack.getItem()).stream().map(InsulatorData::insulation).flatMap(Collection::stream).filter(ins -> !ins.isEmpty()).toList();
    }

    public static List<InsulatorData> getInsulatorsForStack(ItemStack stack, Insulation.Slot slot) {
        if (stack.isEmpty()) {
            return new ArrayList<InsulatorData>();
        }
        ArrayList<InsulatorData> insulators = new ArrayList<InsulatorData>();
        if (slot == Insulation.Slot.ARMOR && ItemInsulationManager.isInsulatable(stack)) {
            ItemInsulationManager.getInsulationCap(stack).ifPresent(cap -> insulators.addAll(ItemInsulationManager.getAppliedArmorInsulators(stack)));
        }
        insulators.addAll(ItemInsulationManager.getInsulatorsForSlotType(slot).get((Object)stack.getItem()));
        return insulators;
    }

    public static List<InsulatorData> getAppliedArmorInsulators(ItemStack armor) {
        return ((List)ItemInsulationManager.getInsulationCap(armor).map(ItemInsulationCap::getInsulation).orElse(new ArrayList())).stream().map(Pair::getSecond).flatMap(Collection::stream).toList();
    }

    public static List<AttributeModifier> getArmorInsulationAttributes(ItemStack stack, Holder<Attribute> attribute, @Nullable AttributeModifier.Operation operation, @Nullable Entity owner) {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();
        for (InsulatorData insulator : ItemInsulationManager.getInsulatorsForStack(stack, Insulation.Slot.ARMOR)) {
            if (!insulator.test(owner, stack)) continue;
            modifiers.addAll(insulator.attributes().get(attribute).stream().filter(mod -> operation == null || mod.operation() == operation).toList());
        }
        return modifiers;
    }

    public static List<AttributeModifier> getAttributeModifiersForSlot(ItemStack stack, Holder<Attribute> attribute, EquipmentSlot slot, @Nullable AttributeModifier.Operation operation, @Nullable Entity owner) {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>((operation != null ? ItemStackHelper.getAttributeModifiers(stack, slot).filter(entry -> entry.attribute().equals((Object)Holder.direct((Object)attribute))).filter(entry -> entry.modifier().operation() == operation) : ItemStackHelper.getAttributeModifiers(stack, slot).filter(entry -> entry.attribute().equals((Object)Holder.direct((Object)attribute)))).map(ItemAttributeModifiers.Entry::modifier).toList());
        modifiers.addAll(ItemInsulationManager.getArmorInsulationAttributes(stack, attribute, operation, owner));
        return modifiers;
    }

    public static List<AttributeModifier> getAttributeModifiersForSlot(ItemStack stack, Holder<Attribute> attribute, EquipmentSlot slot) {
        return ItemInsulationManager.getAttributeModifiersForSlot(stack, attribute, slot, null, null);
    }

    @EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void handleInventoryOpen(PlayerContainerEvent event) {
            event.getEntity().getPersistentData().putBoolean("InventoryOpen", event instanceof PlayerContainerEvent.Open);
        }
    }
}

