/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.container;

import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModMenus;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.Objects;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class HearthContainer
extends AbstractContainerMenu {
    public final HearthBlockEntity te;

    public HearthContainer(int windowId, Inventory playerInv, final HearthBlockEntity te) {
        super((MenuType)ModMenus.HEARTH_CONTAINER_TYPE.get(), windowId);
        this.te = te;
        this.addSlot(new Slot(this, (Container)te, 0, 80, 48){

            public boolean mayPlace(ItemStack stack) {
                if (te.getItemFuel(stack) != 0 || stack.is(Items.MILK_BUCKET)) {
                    return true;
                }
                if (stack.has(DataComponents.POTION_CONTENTS)) {
                    PotionContents potioncontents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
                    for (MobEffectInstance effect : potioncontents.getAllEffects()) {
                        if (!ConfigSettings.HEARTH_POTION_BLACKLIST.get().contains(effect.getEffect())) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInv, col + 9 * row + 9, 8 + col * 18, 166 - (4 - row) * 18 - 10));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInv, col, 8 + col * 18, 142));
        }
    }

    public HearthContainer(int windowId, Inventory playerInv, FriendlyByteBuf data) {
        this(windowId, playerInv, HearthContainer.getTileEntity(playerInv, data));
    }

    public int getHotFuel() {
        return this.te.getHotFuel();
    }

    public int getColdFuel() {
        return this.te.getColdFuel();
    }

    private static HearthBlockEntity getTileEntity(Inventory playerInv, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInv, "Player inventory cannot be null");
        Objects.requireNonNull(data, "PacketBuffer inventory cannot be null");
        BlockEntity te = playerInv.player.level().getBlockEntity(data.readBlockPos());
        if (te instanceof HearthBlockEntity) {
            HearthBlockEntity hearth = (HearthBlockEntity)te;
            return hearth;
        }
        throw new IllegalStateException("Tile Entity is not correct");
    }

    public boolean stillValid(Player playerIn) {
        return playerIn.distanceToSqr(Vec3.atCenterOf((Vec3i)this.te.getBlockPos())) <= 64.0;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 0) {
                if (!this.moveItemStackTo(itemstack1, 1, 37, true)) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (this.getSlot(0).mayPlace(itemstack)) {
                    if (!this.moveItemStackTo(itemstack1, 0, 1, false)) {
                        return ItemStack.EMPTY;
                    }
                } else if (CSMath.betweenInclusive(index, this.slots.size() - 9, this.slots.size() - 1)) {
                    if (!this.moveItemStackTo(itemstack1, 1, this.slots.size() - 10, false)) {
                        slot.onQuickCraft(itemstack1, itemstack);
                        return ItemStack.EMPTY;
                    }
                } else if (CSMath.betweenInclusive(index, 1.0, this.slots.size() - 10) && !this.moveItemStackTo(itemstack1, this.slots.size() - 9, this.slots.size(), false)) {
                    slot.onQuickCraft(itemstack1, itemstack);
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            slot.onQuickCraft(itemstack1, itemstack);
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }
}

