/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.item;

import com.momosoftworks.coldsweat.common.block.SoulStalkBlock;
import com.momosoftworks.coldsweat.core.init.ModBlocks;
import com.momosoftworks.coldsweat.core.init.ModItems;
import com.momosoftworks.coldsweat.data.tag.ModBlockTags;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SoulSproutItem
extends ItemNameBlockItem {
    public static final DispenseItemBehavior DISPENSE_BEHAVIOR = new DefaultDispenseItemBehavior(){

        protected ItemStack execute(BlockSource source, ItemStack stack) {
            if (stack.is(ModItems.SOUL_SPROUT)) {
                ServerLevel level = source.level();
                Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
                BlockPos frontPos = BlockPos.containing((Position)DispenserBlock.getDispensePosition((BlockSource)source));
                BlockState frontState = level.getBlockState(frontPos);
                BlockState groundState = level.getBlockState(frontPos.below());
                if (frontState.canBeReplaced() && frontState.getFluidState().isEmpty() && groundState.is(ModBlockTags.SOUL_STALK_PLACEABLE_ON)) {
                    level.setBlock(frontPos, (BlockState)((Block)ModBlocks.SOUL_STALK.value()).defaultBlockState().setValue(SoulStalkBlock.SECTION, (Comparable)((Object)SoulStalkBlock.Section.BUD)), 3);
                    this.playAnimation(source, direction);
                    this.playSound(source);
                    stack.shrink(1);
                    return stack;
                }
            }
            return super.execute(source, stack);
        }
    };

    public SoulSproutItem(Block block, Item.Properties properties) {
        super(block, properties);
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)DISPENSE_BEHAVIOR);
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        AdvancementHolder seedyPlace;
        ServerPlayer player;
        Player player2;
        boolean placed = super.placeBlock(context, state);
        if (placed && (player2 = context.getPlayer()) instanceof ServerPlayer && (player = (ServerPlayer)player2).getServer() != null && (seedyPlace = player.getServer().getAdvancements().get(ResourceLocation.withDefaultNamespace((String)"husbandry/plant_seed"))) != null) {
            player.getAdvancements().award(seedyPlace, "nether_wart");
        }
        return placed;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        entity.clearFire();
        return super.finishUsingItem(stack, level, entity);
    }
}

