/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.impl.RequirementHolder;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.WorldTempRequirement;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class EntityTempData
extends ConfigData
implements RequirementHolder {
    final NegatableList<EntityRequirement> entity;
    final double temperature;
    final double range;
    final Temperature.Units units;
    final NegatableList<EntityRequirement> affectedEntity;
    final double maxEffect;
    final WorldTempRequirement maxTemp;
    final WorldTempRequirement minTemp;
    final boolean affectsSelf;
    public static final Codec<EntityTempData> CODEC = EntityTempData.createCodec(RecordCodecBuilder.mapCodec(instance -> instance.group((App)NegatableList.codec(EntityRequirement.getCodec()).optionalFieldOf("entity", new NegatableList()).forGetter(EntityTempData::entity), (App)Codec.DOUBLE.fieldOf("temperature").forGetter(EntityTempData::temperature), (App)Codec.DOUBLE.fieldOf("range").forGetter(EntityTempData::range), (App)Temperature.Units.CODEC.optionalFieldOf("units", (Object)Temperature.Units.MC).forGetter(EntityTempData::units), (App)NegatableList.codec(EntityRequirement.getCodec()).optionalFieldOf("affected_entity", new NegatableList()).forGetter(EntityTempData::affectedEntity), (App)Codec.DOUBLE.optionalFieldOf("max_effect", (Object)Double.POSITIVE_INFINITY).forGetter(EntityTempData::maxEffect), (App)WorldTempRequirement.CODEC.optionalFieldOf("max_temp", (Object)WorldTempRequirement.INFINITY).forGetter(data -> data.maxTemp), (App)WorldTempRequirement.CODEC.optionalFieldOf("min_temp", (Object)WorldTempRequirement.NEGATIVE_INFINITY).forGetter(data -> data.minTemp), (App)Codec.BOOL.optionalFieldOf("affects_self", (Object)false).forGetter(EntityTempData::affectsSelf)).apply((Applicative)instance, EntityTempData::new)));

    public EntityTempData(NegatableList<EntityRequirement> entity, double temperature, double range, Temperature.Units units, NegatableList<EntityRequirement> affectedEntity, double maxEffect, WorldTempRequirement maxTemp, WorldTempRequirement minTemp, boolean affectsSelf, NegatableList<String> requiredMods) {
        super(requiredMods);
        this.entity = entity;
        this.temperature = temperature;
        this.range = range;
        this.units = units;
        this.affectedEntity = affectedEntity;
        this.maxEffect = maxEffect;
        this.maxTemp = maxTemp;
        this.minTemp = minTemp;
        this.affectsSelf = affectsSelf;
    }

    public EntityTempData(NegatableList<EntityRequirement> entity, double temperature, double range, Temperature.Units units, NegatableList<EntityRequirement> affectedEntity, double maxEffect, WorldTempRequirement maxTemp, WorldTempRequirement minTemp, boolean affectsSelf) {
        this(entity, temperature, range, units, affectedEntity, maxEffect, maxTemp, minTemp, affectsSelf, new NegatableList<String>());
    }

    public NegatableList<EntityRequirement> entity() {
        return this.entity;
    }

    public double temperature() {
        return this.temperature;
    }

    public double range() {
        return this.range;
    }

    public Temperature.Units units() {
        return this.units;
    }

    public NegatableList<EntityRequirement> affectedEntity() {
        return this.affectedEntity;
    }

    public double maxEffect() {
        return this.maxEffect;
    }

    public WorldTempRequirement maxTemp() {
        return this.maxTemp;
    }

    public WorldTempRequirement minTemp() {
        return this.minTemp;
    }

    public boolean affectsSelf() {
        return this.affectsSelf;
    }

    public double getTemperature() {
        return Temperature.convert(this.temperature, this.units, Temperature.Units.MC, false);
    }

    public double getMaxEffect() {
        return Temperature.convert(this.maxEffect, this.units, Temperature.Units.MC, false);
    }

    public double getMaxTemp() {
        return this.maxTemp.get(this.units);
    }

    public double getMinTemp() {
        return this.minTemp.get(this.units);
    }

    @Nullable
    public static EntityTempData fromToml(List<?> entry) {
        if (entry.size() < 3) {
            ColdSweat.LOGGER.error("Error parsing entity temp config: not enough arguments");
            return null;
        }
        NegatableList<Either<TagKey<EntityType<?>>, EntityType<?>>> entities = ConfigHelper.getEntityTypes((String)entry.get(0));
        if (entities.isEmpty()) {
            return null;
        }
        double temp = ((Number)entry.get(1)).doubleValue();
        double range = ((Number)entry.get(2)).doubleValue();
        Temperature.Units units = entry.size() > 3 ? Temperature.Units.fromID((String)entry.get(3)) : Temperature.Units.MC;
        double maxEffect = entry.size() > 4 ? ((Number)entry.get(4)).doubleValue() : Double.POSITIVE_INFINITY;
        double tempLimit = entry.size() > 5 ? ((Number)entry.get(5)).doubleValue() : Double.POSITIVE_INFINITY;
        WorldTempRequirement maxTemp = new WorldTempRequirement(temp > 0.0 ? tempLimit : Double.POSITIVE_INFINITY);
        WorldTempRequirement minTemp = new WorldTempRequirement(temp < 0.0 ? -tempLimit : Double.NEGATIVE_INFINITY);
        EntityRequirement requirement = new EntityRequirement(entities);
        EntityTempData result = new EntityTempData(new NegatableList<EntityRequirement>(requirement), temp, range, units, new NegatableList<EntityRequirement>(), maxEffect, maxTemp, minTemp, false);
        result.setConfigType(ConfigData.Type.TOML);
        return result;
    }

    @Override
    public boolean test(Entity entity) {
        return this.entity.test((T req) -> req.test(entity));
    }

    public boolean test(Entity entity, Entity affectedEntity) {
        return (this.affectsSelf || entity != affectedEntity) && (double)entity.distanceTo(affectedEntity) <= this.range && this.test(entity) && this.affectedEntity.test((T req) -> req.test(affectedEntity));
    }

    public double getTemperatureEffect(Entity entity, Entity affectedPlayer) {
        return CSMath.blend(0.0, this.getTemperature(), (double)entity.distanceTo(affectedPlayer), this.range, 0.0);
    }

    public Codec<EntityTempData> getCodec() {
        return CODEC;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EntityTempData that = (EntityTempData)obj;
        return super.equals(obj) && Double.compare(that.temperature, this.temperature) == 0 && Double.compare(that.range, this.range) == 0 && this.entity.equals(that.entity) && this.units == that.units && this.affectedEntity.equals(that.affectedEntity) && Double.compare(that.maxEffect, this.maxEffect) == 0 && this.affectsSelf == that.affectsSelf;
    }
}

