/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.item.ItemStack;

public record ItemComponentsRequirement(CompoundTag components) {
    public static final Codec<ItemComponentsRequirement> CODEC = CompoundTag.CODEC.xmap(ItemComponentsRequirement::new, ItemComponentsRequirement::components);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemComponentsRequirement> STREAM_CODEC = StreamCodec.of((buf, requirement) -> buf.writeNbt((Tag)requirement.components()), buf -> new ItemComponentsRequirement(buf.readNbt()));

    public ItemComponentsRequirement() {
        this(new CompoundTag());
    }

    public boolean test(ItemStack stack) {
        return this.components().isEmpty() || this.test(stack.getComponentsPatch(), (HolderLookup.Provider)RegistryHelper.getRegistryAccess());
    }

    public boolean test(@Nullable DataComponentPatch components, HolderLookup.Provider registryAccess) {
        CompoundTag serialized = DataComponentPatch.CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registryAccess), (Object)components).result().orElse(new CompoundTag());
        return NbtRequirement.compareNbt((Tag)this.components, (Tag)serialized);
    }

    public static ItemComponentsRequirement parse(String data) {
        if (!((String)data).startsWith("{")) {
            data = "{" + (String)data + "}";
        }
        return new ItemComponentsRequirement(NBTHelper.parseCompoundNbt((String)data));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ItemComponentsRequirement that = (ItemComponentsRequirement)obj;
        return this.components.equals((Object)that.components);
    }

    @Override
    public String toString() {
        return "ItemComponents{components=" + String.valueOf(this.components) + "}";
    }
}

