/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.BiomeTempData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.Tags;

public class CaveBiomeTempModifier
extends TempModifier {
    public CaveBiomeTempModifier() {
        this(6);
    }

    public CaveBiomeTempModifier(int samples) {
        this.getNBT().m_128405_("SampleRoot", samples);
    }

    @Override
    protected Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        int sampleRoot = this.getNBT().m_128451_("SampleRoot");
        Level level = entity.f_19853_;
        double biomeTempTotal = 0.0;
        int caveBiomeCount = 0;
        for (BlockPos pos : WorldHelper.getPositionCube(entity.m_20183_(), sampleRoot, 6)) {
            BiomeTempData biomeTempData;
            Holder biome;
            if (!level.m_46739_(pos) || (double)WorldHelper.getHeight(pos, level) <= entity.m_20186_() || !(biome = level.m_7062_().m_204214_(pos)).m_203656_(Tags.Biomes.IS_UNDERGROUND) || CSMath.getIfNotNull(biomeTempData = ConfigSettings.BIOME_TEMPS.get(level.m_5962_()).get(biome), BiomeTempData::isDisabled, false).booleanValue()) continue;
            Pair<Double, Double> biomeTempRange = WorldHelper.getBiomeTemperatureRange((LevelAccessor)level, (Holder<Biome>)biome);
            double biomeTemp = CSMath.averagePair(biomeTempRange);
            biomeTempTotal += biomeTemp;
            ++caveBiomeCount;
        }
        if (caveBiomeCount == 0) {
            return temp -> temp;
        }
        int finalCaveBiomeCount = caveBiomeCount;
        double biomeTempAvg = biomeTempTotal / (double)caveBiomeCount;
        return temp -> CSMath.blend(temp, biomeTempAvg, (double)finalCaveBiomeCount, 0.0, Math.pow(sampleRoot, 3.0));
    }
}

