/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier.compat;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import earth.terrarium.ad_astra.common.item.armor.SpaceSuit;
import earth.terrarium.ad_astra.common.util.OxygenUtils;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class AdAstraOxygenTempModifier
extends TempModifier {
    @Override
    protected Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        if (!entity.f_19853_.f_46443_) {
            Level level = entity.f_19853_;
            BlockPos pos = entity.m_20183_();
            if (!OxygenUtils.posHasOxygen((Level)level, (BlockPos)pos) && SpaceSuit.hasOxygenatedSpaceSuit((LivingEntity)entity)) {
                return temp -> CSMath.blend(temp, Temperature.getNeutralWorldTemp(entity), 0.75, 0.0, 1.0);
            }
            if (!OxygenUtils.levelHasOxygen((Level)level) && OxygenUtils.posHasOxygen((Level)level, (BlockPos)pos)) {
                return temp -> CSMath.blend(temp, Temperature.getNeutralWorldTemp(entity), ConfigSettings.THERMAL_SOURCE_STRENGTH.get() * 1.2, 0.0, 1.0);
            }
        }
        return temp -> temp;
    }
}

