/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.util;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.api.annotation.Internal;
import com.momosoftworks.coldsweat.api.event.common.temperautre.TempModifierEvent;
import com.momosoftworks.coldsweat.api.event.common.temperautre.TemperatureChangedEvent;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.SyncTempModifiersMessage;
import com.momosoftworks.coldsweat.core.network.message.SyncTemperatureMessage;
import com.momosoftworks.coldsweat.data.codec.util.ExtraCodecs;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.InterruptibleIterator;
import com.momosoftworks.coldsweat.util.serialization.EnumHelper;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;

public class Temperature {
    private Temperature() {
    }

    public static double convert(double value, Units from, Units to, boolean absolute) {
        return switch (from) {
            default -> throw new IncompatibleClassChangeError();
            case Units.C -> {
                switch (to) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case C: {
                        yield value;
                    }
                    case F: {
                        yield value * 1.8 + (absolute ? 32.0 : 0.0);
                    }
                    case MC: 
                }
                yield value / 25.0;
            }
            case Units.F -> {
                switch (to) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case C: {
                        yield (value - (absolute ? 32.0 : 0.0)) / 1.8;
                    }
                    case F: {
                        yield value;
                    }
                    case MC: 
                }
                yield (value - (absolute ? 32.0 : 0.0)) / 45.0;
            }
            case Units.MC -> {
                switch (to) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case C: {
                        yield value * 25.0;
                    }
                    case F: {
                        yield value * 45.0 + (absolute ? 32.0 : 0.0);
                    }
                    case MC: 
                }
                yield value;
            }
        };
    }

    public static double convertIfNeeded(double value, Trait trait, Units units) {
        if (trait.isForWorld()) {
            return Temperature.convert(value, Units.MC, units, true);
        }
        return value;
    }

    public static double get(LivingEntity entity, Trait trait) {
        return EntityTempManager.getTemperatureCap((Entity)entity).map(cap -> cap.getTrait(trait)).orElse(0.0);
    }

    public static void set(LivingEntity entity, Trait trait, double value) {
        TemperatureChangedEvent event = new TemperatureChangedEvent(entity, trait, Temperature.get(entity, trait), value);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> cap.setTrait(trait, event.getTemperature()));
        Temperature.updateTemperature(entity);
    }

    public static void add(LivingEntity entity, Trait trait, double value) {
        double oldTemp = Temperature.get(entity, trait);
        TemperatureChangedEvent event = new TemperatureChangedEvent(entity, trait, oldTemp, oldTemp + value);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> cap.setTrait(trait, event.getTemperature()));
        Temperature.updateTemperature(entity);
    }

    public static double apply(double currentTemp, LivingEntity entity, Trait trait, boolean ignoreTickMultiplier, TempModifier ... modifiers) {
        if (modifiers.length == 0) {
            return currentTemp;
        }
        double temp2 = currentTemp;
        for (TempModifier modifier : modifiers) {
            double newTemp;
            if (modifier == null) continue;
            int tickRate = ignoreTickMultiplier ? modifier.getTickRate() : (int)((double)modifier.getTickRate() / ConfigSettings.MODIFIER_TICK_RATE.get());
            double d = newTemp = entity.f_19797_ % tickRate == 0 || modifier.getTicksExisted() == 0 || entity.f_19797_ <= 1 ? modifier.update(temp2, entity, trait) : modifier.apply(trait, temp2);
            if (Double.isNaN(newTemp)) continue;
            temp2 = newTemp;
        }
        return temp2;
    }

    public static double apply(double currentTemp, LivingEntity entity, Trait trait, TempModifier ... modifiers) {
        return Temperature.apply(currentTemp, entity, trait, false, modifiers);
    }

    public static double apply(double temp, LivingEntity entity, Trait trait, Collection<TempModifier> modifiers, boolean ignoreTickMultiplier) {
        return Temperature.apply(temp, entity, trait, ignoreTickMultiplier, modifiers.toArray(new TempModifier[0]));
    }

    public static double apply(double temp, LivingEntity entity, Trait trait, Collection<TempModifier> modifiers) {
        return Temperature.apply(temp, entity, trait, false, modifiers.toArray(new TempModifier[0]));
    }

    public static boolean hasModifier(LivingEntity entity, Trait trait, Class<? extends TempModifier> modClass) {
        return EntityTempManager.getTemperatureCap((Entity)entity).map(cap -> cap.hasModifier(trait, modClass)).orElse(false);
    }

    public static <T extends TempModifier> Optional<T> getModifier(LivingEntity entity, Trait trait, Class<T> modClass) {
        return EntityTempManager.getTemperatureCap((Entity)entity).map(cap -> Temperature.getModifier(cap, trait, modClass)).orElse(Optional.empty());
    }

    public static <T extends TempModifier> Optional<T> getModifier(ITemperatureCap cap, Trait trait, Class<T> modClass) {
        return cap.getModifiers(trait).stream().filter(modClass::isInstance).findFirst();
    }

    public static List<TempModifier> getModifiers(LivingEntity entity, Trait trait, Predicate<TempModifier> condition) {
        return Temperature.getModifiers(entity, trait).stream().filter(condition).toList();
    }

    public static Optional<TempModifier> getModifier(LivingEntity entity, Trait trait, Predicate<TempModifier> condition) {
        return Temperature.getModifiers(entity, trait).stream().filter(condition).findFirst();
    }

    public static boolean addOrReplaceModifier(LivingEntity entity, TempModifier modifier, Trait trait, Placement.Duplicates matchPolicy) {
        return Temperature.addModifier(entity, modifier, trait, Placement.Duplicates.ALLOW, 1, Placement.of(Placement.Mode.REPLACE_OR_ADD, Placement.Order.FIRST, mod -> matchPolicy.check(modifier, (TempModifier)mod)));
    }

    public static boolean replaceModifier(LivingEntity entity, TempModifier modifier, Trait trait, Placement.Duplicates matchPolicy) {
        return Temperature.addModifier(entity, modifier, trait, Placement.Duplicates.ALLOW, 1, Placement.of(Placement.Mode.REPLACE, Placement.Order.FIRST, mod -> matchPolicy.check(modifier, (TempModifier)mod)));
    }

    public static boolean addModifier(LivingEntity entity, TempModifier modifier, Trait trait, Placement.Duplicates duplicates) {
        return Temperature.addModifier(entity, modifier, trait, duplicates, 1, Placement.AFTER_LAST);
    }

    public static boolean addModifier(LivingEntity entity, TempModifier modifier, Trait trait, Placement.Duplicates duplicates, int maxCount, Placement placement) {
        LazyOptional<ITemperatureCap> optCap;
        TempModifierEvent.Add event = new TempModifierEvent.Add(entity, trait, modifier);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled() && (optCap = EntityTempManager.getTemperatureCap((Entity)entity)).resolve().isPresent()) {
            ITemperatureCap cap = (ITemperatureCap)optCap.resolve().get();
            List<TempModifier> modifiers = cap.getModifiers(trait);
            if (Temperature.addModifier(modifiers, event.getModifier(), duplicates, maxCount, placement)) {
                modifier.onAdded(entity, trait);
                Temperature.updateSiblingsAdd(modifiers, entity, trait, modifier);
                Temperature.updateModifiers(entity, cap);
                return true;
            }
            return false;
        }
        return false;
    }

    @Internal
    public static boolean addModifier(List<TempModifier> modifiers, TempModifier modifier, Placement.Duplicates duplicatePolicy, int maxCount, Placement placement) {
        int start;
        boolean changed = false;
        Predicate<TempModifier> predicate = placement.predicate();
        if (predicate == null) {
            predicate = mod -> true;
        }
        boolean isReplacing = placement.mode().isReplacing();
        boolean isForward = placement.order() == Placement.Order.FIRST;
        int existingMatches = (int)modifiers.stream().filter(mod -> duplicatePolicy.check(modifier, (TempModifier)mod)).count();
        int hits = isReplacing ? 0 : existingMatches;
        int i = start = isForward ? 0 : modifiers.size() - 1;
        while (isForward ? i < modifiers.size() : i >= 0) {
            if (hits >= maxCount) {
                return changed;
            }
            TempModifier modifierAt = modifiers.get(i);
            if (predicate.test(modifierAt)) {
                if (isReplacing) {
                    changed = modifierAt.getExpireTime() != -1 || modifier.getExpireTime() != -1 || !modifierAt.equals(modifier);
                    modifiers.set(i, modifier);
                } else {
                    modifiers.add(i + (placement.mode() == Placement.Mode.AFTER ? 1 : 0), modifier);
                    changed = true;
                }
                ++hits;
            }
            i += isForward ? 1 : -1;
        }
        if (hits > 0) {
            return changed;
        }
        switch (placement.mode()) {
            case BEFORE: {
                modifiers.add(0, modifier);
                return true;
            }
            case AFTER: 
            case REPLACE_OR_ADD: {
                modifiers.add(modifier);
                return true;
            }
        }
        return changed;
    }

    public static void addModifiers(LivingEntity entity, List<TempModifier> modifiers, Trait trait, Placement.Duplicates duplicatePolicy) {
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> {
            boolean changed = false;
            for (TempModifier modifier : modifiers) {
                changed |= Temperature.addModifier(entity, modifier, trait, duplicatePolicy);
            }
            if (changed) {
                Temperature.updateModifiers(entity, cap);
            }
        });
    }

    public static void removeModifiers(LivingEntity entity, Trait trait, int maxCount, Placement.Order order, Predicate<TempModifier> condition) {
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> {
            int i;
            List<TempModifier> modifiers = cap.getModifiers(trait);
            boolean forwardOrder = order == Placement.Order.FIRST;
            int removed = 0;
            int n = i = forwardOrder ? 0 : modifiers.size() - 1;
            while (i >= 0 && i < modifiers.size() && removed < maxCount) {
                TempModifier modifier = modifiers.get(i);
                if (condition.test(modifier)) {
                    TempModifierEvent.Remove event = new TempModifierEvent.Remove(entity, trait, modifier);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    if (!event.isCanceled()) {
                        cap.removeModifier(modifier, trait);
                        modifier.onRemoved(entity, trait);
                        Temperature.updateSiblingsRemove(modifiers, entity, trait, modifier);
                        i += forwardOrder ? -1 : 1;
                        ++removed;
                    }
                }
                i += forwardOrder ? 1 : -1;
            }
            if (removed > 0) {
                Temperature.updateModifiers(entity, cap);
            }
        });
    }

    public static void removeModifiers(LivingEntity entity, Trait trait, Predicate<TempModifier> condition) {
        Temperature.removeModifiers(entity, trait, Integer.MAX_VALUE, Placement.Order.FIRST, condition);
    }

    public static void removeModifiers(LivingEntity entity, Trait trait, Class<? extends TempModifier> clazz) {
        Temperature.removeModifiers(entity, trait, Integer.MAX_VALUE, Placement.Order.FIRST, clazz::isInstance);
    }

    public static List<TempModifier> getModifiers(LivingEntity entity, Trait trait) {
        return (List)EntityTempManager.getTemperatureCap((Entity)entity).map(cap -> ImmutableList.copyOf(cap.getModifiers(trait))).orElse(ImmutableList.of());
    }

    public static void forEachModifier(LivingEntity entity, Trait trait, Consumer<TempModifier> action) {
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> cap.getModifiers(trait).forEach(action));
    }

    public static void forEachModifier(LivingEntity entity, Trait trait, BiConsumer<TempModifier, InterruptibleIterator<TempModifier>> action) {
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> CSMath.breakableForEach(cap.getModifiers(trait), action));
    }

    public static double getNeutralWorldTemp(LivingEntity entity) {
        return (Temperature.get(entity, Trait.BURNING_POINT) + Temperature.get(entity, Trait.FREEZING_POINT)) / 2.0;
    }

    @Internal
    public static void updateSiblingsAdd(List<TempModifier> modifiers, LivingEntity entity, Trait trait, TempModifier modifier) {
        modifiers.forEach(mod -> {
            if (mod == modifier) {
                return;
            }
            mod.onSiblingAdded(entity, trait, modifier);
        });
    }

    @Internal
    public static void updateSiblingsRemove(List<TempModifier> modifiers, LivingEntity entity, Trait trait, TempModifier modifier) {
        modifiers.forEach(mod -> {
            if (mod == modifier) {
                return;
            }
            mod.onSiblingRemoved(entity, trait, modifier);
        });
    }

    public static void updateTemperature(LivingEntity entity, ITemperatureCap cap, boolean instant) {
        if (!entity.f_19853_.f_46443_) {
            ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new SyncTemperatureMessage(entity, cap.serializeTraits(), instant));
        }
    }

    public static void updateTemperature(LivingEntity entity) {
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> cap.syncValues(entity));
    }

    public static void updateModifiers(LivingEntity entity, ITemperatureCap cap) {
        if (!entity.f_19853_.f_46443_) {
            ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new SyncTempModifiersMessage(entity, cap.serializeModifiers()));
        }
    }

    public static void updateModifiers(LivingEntity entity) {
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> Temperature.updateModifiers(entity, cap));
    }

    public static Map<Trait, Double> getTemperatures(LivingEntity entity) {
        return EntityTempManager.getTemperatureCap((Entity)entity).map(ITemperatureCap::getTraits).orElse(new EnumMap(Trait.class));
    }

    public static EnumMap<Trait, List<TempModifier>> getModifiers(LivingEntity entity) {
        return EntityTempManager.getTemperatureCap((Entity)entity).map(ITemperatureCap::getModifiers).orElseGet(() -> new EnumMap(Trait.class));
    }

    public static void clearModifiers(LivingEntity entity, Trait trait) {
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> cap.clearModifiers(trait));
    }

    public static enum Units implements StringRepresentable
    {
        F("\u00b0F", "f"),
        C("\u00b0C", "c"),
        MC("MC", "mc");

        public static final Codec<Units> CODEC;
        private final String name;
        private final String id;

        private Units(String name, String id) {
            this.name = name;
            this.id = id;
        }

        public static Units fromID(String name) {
            return (Units)EnumHelper.byName((Enum[])Units.values(), (String)name);
        }

        public String getFormattedName() {
            return this.name;
        }

        public String m_7912_() {
            return this.id;
        }

        static {
            CODEC = ExtraCodecs.enumIgnoreCase((Enum[])Units.values());
        }
    }

    public static enum Trait implements StringRepresentable
    {
        WORLD("world", true, true, true),
        CORE("core", true, true, false),
        BASE("base", true, true, true),
        BODY("body", false, false, false),
        RATE("rate", true, true, true),
        FREEZING_POINT("freezing_point", true, true, true),
        BURNING_POINT("burning_point", true, true, true),
        COLD_RESISTANCE("cold_resistance", true, true, true),
        HEAT_RESISTANCE("heat_resistance", true, true, true),
        COLD_DAMPENING("cold_dampening", true, true, true),
        HEAT_DAMPENING("heat_dampening", true, true, true);

        public static final Codec<Trait> CODEC;
        private final String id;
        private final boolean forTemperature;
        private final boolean forModifiers;
        private final boolean forAttributes;

        private Trait(String id, boolean forTemperature, boolean forModifiers, boolean forAttributes) {
            this.id = id;
            this.forTemperature = forTemperature;
            this.forModifiers = forModifiers;
            this.forAttributes = forAttributes;
        }

        public boolean isForTemperature() {
            return this.forTemperature;
        }

        public boolean isForModifiers() {
            return this.forModifiers;
        }

        public boolean isForAttributes() {
            return this.forAttributes;
        }

        public boolean isForWorld() {
            return this == WORLD || this == BURNING_POINT || this == FREEZING_POINT;
        }

        public static Trait fromID(String name) {
            return (Trait)EnumHelper.byName((Enum[])Trait.values(), (String)name);
        }

        public String m_7912_() {
            return this.id;
        }

        static {
            CODEC = ExtraCodecs.enumIgnoreCase((Enum[])Trait.values());
        }
    }
}

