/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.momosoftworks.coldsweat.api.temperature.modifier.WaterTempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.Vec2f;
import com.momosoftworks.coldsweat.util.math.Vec2i;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import oshi.util.tuples.Triplet;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class WetnessRenderer {
    private static final ResourceLocation WATER_DROP = new ResourceLocation("cold_sweat", "textures/gui/overlay/droplet.png");
    private static final ResourceLocation WATER_DROP_TRAIL = new ResourceLocation("cold_sweat", "textures/gui/overlay/droplet_trail.png");
    private static final List<Droplet> WATER_DROPS = new ArrayList<Droplet>();
    private static final List<Triplet<Vec2i, Float, Integer>> TRAILS = new ArrayList<Triplet<Vec2i, Float, Integer>>();
    private static boolean WAS_SUBMERGED = false;
    private static int LEFT_DROPLETS = 0;
    private static int RIGHT_DROPLETS = 0;
    private static final int MAX_DROPLETS = 5;

    @SubscribeEvent
    public static void updateSkyBrightness(TickEvent.ClientTickEvent event) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            level.m_46465_();
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiEvent.Pre event) {
        float alpha;
        Object pos;
        int i;
        boolean justExitedWater;
        LocalPlayer player;
        if (!ConfigSettings.WATER_EFFECT_SETTING.get().showGui()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        PoseStack ps = event.getPoseStack();
        float frametime = mc.m_91297_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        boolean paused = mc.m_91104_();
        int uiScale = (Integer)mc.f_91066_.m_231928_().m_231551_();
        if (uiScale == 0) {
            uiScale = mc.m_91268_().m_85385_(0, mc.m_91390_());
        }
        if ((player = mc.f_91074_) == null || player.m_5833_()) {
            return;
        }
        BlockPos playerPos = new BlockPos(player.m_146892_());
        float playerYVelocity = (float)(player.m_20182_().f_82480_ - player.f_19791_);
        boolean isSubmerged = player.getEyeInFluidType() == Fluids.f_76193_.getFluidType();
        Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
        double midTemp = (ConfigSettings.MIN_TEMP.get() + ConfigSettings.MAX_TEMP.get()) / 2.0;
        float tempMult = (float)CSMath.blend(1.0, 3.0, Temperature.get((LivingEntity)player, Temperature.Trait.WORLD), midTemp, ConfigSettings.MAX_TEMP.get() * 2.0);
        if (isSubmerged && !paused) {
            TRAILS.clear();
            for (Droplet drop : WATER_DROPS) {
                drop.alpha -= 0.6f * frametime;
                float xMoveDir = drop.position.x < (float)screenWidth / 2.0f ? -1.0f : 1.0f;
                float yMoveDir = drop.position.y < (float)screenHeight / 2.0f ? -1.0f : 1.0f;
                drop.position.add(new Vec2f(xMoveDir, yMoveDir).mul(200.0f * -playerYVelocity * frametime));
            }
        }
        double wetness = Temperature.getModifier((LivingEntity)mc.f_91074_, Temperature.Trait.WORLD, WaterTempModifier.class).map(mod -> CSMath.blend(0.0, 1.0, Math.abs(mod.getTemperature()), 0.0, 0.2)).orElse(0.0);
        boolean bl = justExitedWater = WAS_SUBMERGED && !isSubmerged;
        if (justExitedWater) {
            for (int i2 = 0; i2 < 10; ++i2) {
                Droplet newDrop = WetnessRenderer.createDrop(screenWidth);
                newDrop.yMotion = WetnessRenderer.getRandomVelocity(frametime) / 2.0f + 0.3f;
                newDrop.position.y = (float)(Math.sin(i2 * 4 + player.f_19797_) / 2.0 + 0.5) * (float)screenHeight;
                newDrop.position.x = (float)((double)i2 / 10.0) * (float)screenWidth;
                WATER_DROPS.add(newDrop);
            }
        }
        boolean bl2 = WAS_SUBMERGED = player.m_6084_() && isSubmerged;
        if (!paused && !isSubmerged && wetness > (double)0.01f && (double)((float)Math.random()) * 0.05 < (double)0.0015f * wetness * (double)(frametime * 2.0f) && WATER_DROPS.size() < 5) {
            WATER_DROPS.add(WetnessRenderer.createDrop(screenWidth));
        }
        int waterColor = BiomeColors.m_108811_((BlockAndTintGetter)player.f_19853_, (BlockPos)playerPos);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172829_);
        PoseStack poseStack = event.getPoseStack();
        poseStack.m_85836_();
        int blockLight = player.f_19853_.m_5518_().m_75814_(LightLayer.BLOCK).m_7768_(playerPos);
        int skyLight = player.f_19853_.m_5518_().m_75814_(LightLayer.SKY).m_7768_(playerPos);
        int combinedLight = LightTexture.m_109885_((int)blockLight, (int)skyLight);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WATER_DROP);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        for (i = 0; i < WATER_DROPS.size(); ++i) {
            Droplet drop = WATER_DROPS.get(i);
            pos = drop.position;
            alpha = drop.alpha;
            drop.size = ConfigSettings.WATER_DROPLET_SCALE.get().clamp(drop.size);
            int scaledSize = drop.size / uiScale * 3;
            if (alpha > 0.0f) {
                WetnessRenderer.renderQuadDirect(poseStack, buffer, (int)CSMath.roundNearest(((Vec2f)pos).x, 3.0f / (float)uiScale), (int)((Vec2f)pos).y, scaledSize, scaledSize, 0.0f, 0.0f, 1.0f, 1.0f, alpha, combinedLight, waterColor);
                if (!paused) {
                    drop.alpha = wetness <= 0.0 ? (drop.alpha -= 0.08f * frametime) : (drop.alpha -= 0.003f * frametime * tempMult);
                    if (drop.yMotionUpdateCooldown <= 0.0f) {
                        drop.yMotionUpdateCooldown = (float)Math.random() * 16.0f + 8.0f;
                        drop.yMotion = WetnessRenderer.getRandomVelocity(frametime);
                    } else {
                        drop.yMotionUpdateCooldown -= frametime;
                    }
                    if (drop.XMotionUpdateCooldown <= 0.0f) {
                        drop.XMotionUpdateCooldown = (float)Math.random() * 8.0f + 4.0f;
                        drop.xMotion = (float)Math.random() * 0.02f - 0.01f;
                    }
                    drop.XMotionUpdateCooldown -= frametime;
                    int oldY = (int)((Vec2f)pos).y;
                    if (!isSubmerged) {
                        drop.position.add(new Vec2f(drop.xMotion * drop.yMotion * 20.0f + drop.xVelocity, drop.yMotion).div(uiScale).mul(3.0f));
                    }
                    for (int j = 0; j < Math.max(0, (int)(((Vec2f)pos).y - (float)oldY)); ++j) {
                        TRAILS.add((Triplet<Vec2i, Float, Integer>)new Triplet((Object)new Vec2i((int)((Vec2f)pos).x, oldY + j), (Object)Float.valueOf(alpha), (Object)drop.size));
                    }
                }
                if (((Vec2f)pos).x < -20.0f) {
                    ((Vec2f)pos).x = screenWidth + 20;
                } else if (((Vec2f)pos).x > (float)(screenWidth + 20)) {
                    ((Vec2f)pos).x = -20.0f;
                }
                if (!(((Vec2f)pos).y > (float)screenHeight)) continue;
                WetnessRenderer.removeDrop(drop);
                --i;
                continue;
            }
            WetnessRenderer.removeDrop(drop);
            --i;
        }
        tesselator.m_85914_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)WATER_DROP_TRAIL);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        for (i = 0; i < TRAILS.size(); ++i) {
            Triplet<Vec2i, Float, Integer> trail = TRAILS.get(i);
            pos = (Vec2i)trail.getA();
            alpha = ((Float)trail.getB()).floatValue();
            int size = (Integer)trail.getC();
            if (alpha > 0.0f) {
                WetnessRenderer.renderQuadDirect(poseStack, buffer, (int)CSMath.roundNearest(((Vec2i)pos).x, 3.0f / (float)uiScale * 4.0f), ((Vec2i)pos).y, size / uiScale * 3, 1, 0.0f, 0.0f, 1.0f, 1.0f, alpha, combinedLight, waterColor);
                if (paused) continue;
                alpha = wetness <= 0.0 ? (alpha -= 0.08f * frametime) : (alpha -= 0.045f * frametime * tempMult / 2.0f);
                TRAILS.set(i, (Triplet<Vec2i, Float, Integer>)new Triplet((Object)new Vec2i(((Vec2i)pos).x, ((Vec2i)pos).y), (Object)Float.valueOf(alpha), (Object)size));
                continue;
            }
            TRAILS.remove(trail);
            --i;
        }
        tesselator.m_85914_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.m_91087_().f_91063_.m_109154_().m_109891_();
        poseStack.m_85849_();
    }

    private static float getRandomVelocity(float frametime) {
        return (float)Math.min((double)(0.7f * frametime * 20.0f), Math.pow(Math.random() * 5.0 + (double)0.1f, 3.0) * (double)frametime / 4.0);
    }

    private static Droplet createDrop(int screenWidth) {
        int x;
        Droplet.Side side;
        IntegerBounds dropSize = ConfigSettings.WATER_DROPLET_SCALE.get();
        int size = dropSize.getRandom();
        Droplet.Side side2 = side = Math.random() < 0.5 ? Droplet.Side.LEFT : Droplet.Side.RIGHT;
        if (WetnessRenderer.getDropletsOnSide(side) > WetnessRenderer.getDropletsOnSide(side.opposite())) {
            side = side.opposite();
        }
        int xOffset = (int)(Math.random() * (double)screenWidth / 4.0);
        int n = x = side == Droplet.Side.LEFT ? xOffset : screenWidth - xOffset;
        if (side == Droplet.Side.LEFT) {
            ++LEFT_DROPLETS;
        } else {
            ++RIGHT_DROPLETS;
        }
        return new Droplet(new Vec2f(x, -size), 1.0f, size, side);
    }

    private static void removeDrop(Droplet droplet) {
        if (droplet.side == Droplet.Side.LEFT) {
            --LEFT_DROPLETS;
        } else {
            --RIGHT_DROPLETS;
        }
        WATER_DROPS.remove(droplet);
    }

    private static int getDropletsOnSide(Droplet.Side side) {
        return side == Droplet.Side.LEFT ? LEFT_DROPLETS : RIGHT_DROPLETS;
    }

    private static void renderQuadDirect(PoseStack poseStack, BufferBuilder buffer, int x, int y, int width, int height, float u, float v, float uWidth, float vHeight, float alpha, int lightLevel, int waterColor) {
        alpha = (float)((double)alpha * ConfigSettings.WATER_DROPLET_OPACITY.get());
        float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(waterColor & 0xFF) / 255.0f;
        Matrix4f lastPose = poseStack.m_85850_().m_85861_();
        buffer.m_85982_(lastPose, (float)x, (float)y, 0.0f).m_7421_(u, v).m_85950_(red, green, blue, alpha).m_85969_(lightLevel).m_5752_();
        buffer.m_85982_(lastPose, (float)x, (float)(y + height), 0.0f).m_7421_(u, v + vHeight).m_85950_(red, green, blue, alpha).m_85969_(lightLevel).m_5752_();
        buffer.m_85982_(lastPose, (float)(x + width), (float)(y + height), 0.0f).m_7421_(u + uWidth, v + vHeight).m_85950_(red, green, blue, alpha).m_85969_(lightLevel).m_5752_();
        buffer.m_85982_(lastPose, (float)(x + width), (float)y, 0.0f).m_7421_(u + uWidth, v).m_85950_(red, green, blue, alpha).m_85969_(lightLevel).m_5752_();
    }

    protected static class Droplet {
        public Vec2f position;
        public float alpha;
        public int size;
        public float yMotion = WetnessRenderer.getRandomVelocity(Minecraft.m_91087_().m_91296_() / 5.0f);
        public float xMotion = (float)Math.random() * 0.02f - 0.01f;
        public float xVelocity = 0.0f;
        public float yMotionUpdateCooldown = (float)Math.random() * 16.0f + 8.0f;
        public float XMotionUpdateCooldown = 16.0f;
        public Side side;

        public Droplet(Vec2f position, float alpha, int size, Side side) {
            this.position = position;
            this.alpha = alpha;
            this.size = size;
            this.side = side;
        }

        public static enum Side {
            LEFT,
            RIGHT;


            public Side opposite() {
                return this == LEFT ? RIGHT : LEFT;
            }
        }
    }
}

