/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.momosoftworks.coldsweat.client.gui.AbstractHearthScreen;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.container.HearthContainer;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class HearthScreen
extends AbstractHearthScreen<HearthContainer> {
    private static final ResourceLocation HEARTH_GUI = new ResourceLocation("cold_sweat", "textures/gui/screen/hearth_gui.png");

    @Override
    HearthBlockEntity getBlockEntity() {
        return ((HearthContainer)this.f_97732_).te;
    }

    public HearthScreen(HearthContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, (Component)Component.m_237115_((String)"container.cold_sweat.hearth"));
        this.f_97726_ = 176;
        this.f_97727_ = 166;
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)HEARTH_GUI);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.renderFuelGauge(HearthBlockEntity.FuelType.HOT, poseStack, this.f_97735_ + 62, this.f_97736_ + 49, ((HearthContainer)this.f_97732_).getHotFuel(), ((HearthContainer)this.f_97732_).te.getMaxFuel());
        this.renderFuelGauge(HearthBlockEntity.FuelType.COLD, poseStack, this.f_97735_ + 100, this.f_97736_ + 49, ((HearthContainer)this.f_97732_).getColdFuel(), ((HearthContainer)this.f_97732_).te.getMaxFuel());
        if (!ConfigSettings.SMART_HEARTH.get().booleanValue()) {
            boolean coolingOn = ((HearthContainer)this.f_97732_).te.isCoolingOn();
            boolean heatingOn = ((HearthContainer)this.f_97732_).te.isHeatingOn();
            this.renderPowerIndicator(poseStack, this.f_97735_ + 63, this.f_97736_ + 64, heatingOn);
            this.renderPowerIndicator(poseStack, this.f_97735_ + 101, this.f_97736_ + 64, coolingOn);
            if (CSMath.betweenInclusive(mouseX, this.f_97735_ + 60, this.f_97735_ + 76) && CSMath.betweenInclusive(mouseY, this.f_97736_ + 61, this.f_97736_ + 67)) {
                this.m_96597_(poseStack, List.of(Component.m_237115_((String)(heatingOn ? "gui.cold_sweat.hearth.powered" : "gui.cold_sweat.hearth.unpowered"))), mouseX, mouseY);
            }
            if (CSMath.betweenInclusive(mouseX, this.f_97735_ + 98, this.f_97735_ + 114) && CSMath.betweenInclusive(mouseY, this.f_97736_ + 61, this.f_97736_ + 67)) {
                this.m_96597_(poseStack, List.of(Component.m_237115_((String)(coolingOn ? "gui.cold_sweat.hearth.powered" : "gui.cold_sweat.hearth.unpowered"))), mouseX, mouseY);
            }
        }
    }
}

