/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.command.impl;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.command.BaseCommand;
import com.momosoftworks.coldsweat.common.command.argument.NicerEnumArgument;
import com.momosoftworks.coldsweat.common.command.argument.TempAttributeTraitArgument;
import com.momosoftworks.coldsweat.common.command.argument.TempModifierArgument;
import com.momosoftworks.coldsweat.common.command.argument.TempModifierTraitArgument;
import com.momosoftworks.coldsweat.common.command.argument.TemperatureTraitArgument;
import com.momosoftworks.coldsweat.common.entity.data.Preference;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.NbtTagArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class TempCommand
extends BaseCommand {
    public TempCommand(String name, int permissionLevel, boolean enabled) {
        super(name, permissionLevel, enabled);
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> setExecution() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.builder.then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)-150, (int)150)).executes(source -> this.executeSetEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.m_91461_((CommandContext)source, (String)"entities"), IntegerArgumentType.getInteger((CommandContext)source, (String)"amount"), Temperature.Trait.BODY)))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(source -> this.executeAddEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.m_91461_((CommandContext)source, (String)"entities"), IntegerArgumentType.getInteger((CommandContext)source, (String)"amount"), Temperature.Trait.BODY)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(source -> this.executeGetEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.m_91461_((CommandContext)source, (String)"entities"), Temperature.Trait.BODY))).then(Commands.m_82129_((String)"trait", (ArgumentType)TemperatureTraitArgument.temperatureGet()).executes(source -> this.executeGetEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.m_91461_((CommandContext)source, (String)"entities"), TemperatureTraitArgument.getTemperature((CommandContext<CommandSourceStack>)source, "trait")))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(source -> {
            BlockPos pos = BlockPosArgument.m_118242_((CommandContext)source, (String)"pos");
            return this.executeGetWorldTemp((CommandSourceStack)source.getSource(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), null);
        })).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(source -> this.executeGetWorldTemp((CommandSourceStack)source.getSource(), IntegerArgumentType.getInteger((CommandContext)source, (String)"x"), IntegerArgumentType.getInteger((CommandContext)source, (String)"y"), IntegerArgumentType.getInteger((CommandContext)source, (String)"z"), DimensionArgument.m_88808_((CommandContext)source, (String)"dimension"))))))).then(Commands.m_82127_((String)"debug").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"type", (ArgumentType)TempModifierTraitArgument.modifier()).executes(source -> this.executeDebugModifiers((CommandSourceStack)source.getSource(), EntityArgument.m_91452_((CommandContext)source, (String)"entity"), TempModifierTraitArgument.getModifier((CommandContext<CommandSourceStack>)source, "type"))))))).then(Commands.m_82127_((String)"attribute").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").then(Commands.m_82129_((String)"type", (ArgumentType)TempAttributeTraitArgument.attribute()).executes(source -> this.executeClearModifier((CommandSourceStack)source.getSource(), EntityArgument.m_91461_((CommandContext)source, (String)"entities"), TempAttributeTraitArgument.getAttribute((CommandContext<CommandSourceStack>)source, "type"))))).executes(source -> this.executeClearAllModifiers((CommandSourceStack)source.getSource(), EntityArgument.m_91461_((CommandContext)source, (String)"entities"))))).then(Commands.m_82129_((String)"operation", NicerEnumArgument.enumArgument(AttributeModifier.Operation.class)).then(Commands.m_82129_((String)"type", (ArgumentType)TempAttributeTraitArgument.attribute()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.m_82129_((String)"permanent", (ArgumentType)BoolArgumentType.bool()).executes(source -> this.executeModifyEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.m_91461_((CommandContext)source, (String)"entities"), TempAttributeTraitArgument.getAttribute((CommandContext<CommandSourceStack>)source, "type"), DoubleArgumentType.getDouble((CommandContext)source, (String)"amount"), (AttributeModifier.Operation)source.getArgument("operation", AttributeModifier.Operation.class), BoolArgumentType.getBool((CommandContext)source, (String)"permanent"))))).executes(source -> this.executeModifyEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.m_91461_((CommandContext)source, (String)"entities"), TempAttributeTraitArgument.getAttribute((CommandContext<CommandSourceStack>)source, "type"), DoubleArgumentType.getDouble((CommandContext)source, (String)"amount"), (AttributeModifier.Operation)source.getArgument("operation", AttributeModifier.Operation.class), false)))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"type", (ArgumentType)TempAttributeTraitArgument.attribute()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.m_82129_((String)"permanent", (ArgumentType)BoolArgumentType.bool()).executes(source -> this.executeModifyEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.m_91461_((CommandContext)source, (String)"entities"), TempAttributeTraitArgument.getAttribute((CommandContext<CommandSourceStack>)source, "type"), DoubleArgumentType.getDouble((CommandContext)source, (String)"amount"), null, BoolArgumentType.getBool((CommandContext)source, (String)"permanent"))))).executes(source -> this.executeModifyEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.m_91461_((CommandContext)source, (String)"entities"), TempAttributeTraitArgument.getAttribute((CommandContext<CommandSourceStack>)source, "type"), DoubleArgumentType.getDouble((CommandContext)source, (String)"amount"), null, false)))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"modifier").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"trait", (ArgumentType)TempModifierTraitArgument.modifier()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"modifier", (ArgumentType)TempModifierArgument.modifier()).executes(this::executeAddModifier)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"infinite").executes(this::executeAddModifier)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"tickRate", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(this::executeAddModifier)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"nbt", (ArgumentType)NbtTagArgument.m_100659_()).executes(this::executeAddModifier)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"mode", NicerEnumArgument.enumArgument(Placement.Mode.class)).executes(this::executeAddModifier)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"order", NicerEnumArgument.enumArgument(Placement.Order.class)).executes(this::executeAddModifier)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"match", (ArgumentType)TempModifierArgument.modifier()).executes(this::executeAddModifier)).then(Commands.m_82129_((String)"max", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(this::executeAddModifier)))))).executes(this::executeAddModifier))).executes(this::executeAddModifier)))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(this::executeAddModifier)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"tickRate", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(this::executeAddModifier)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"nbt", (ArgumentType)NbtTagArgument.m_100659_()).executes(this::executeAddModifier)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"mode", NicerEnumArgument.enumArgument(Placement.Mode.class)).executes(this::executeAddModifier)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"order", NicerEnumArgument.enumArgument(Placement.Order.class)).executes(this::executeAddModifier)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"match", (ArgumentType)TempModifierArgument.modifier()).executes(this::executeAddModifier)).then(Commands.m_82129_((String)"max", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(this::executeAddModifier))))).executes(this::executeAddModifier))).executes(this::executeAddModifier))).executes(this::executeAddModifier)))))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"trait", (ArgumentType)TempModifierTraitArgument.modifier()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"modifier", (ArgumentType)TempModifierArgument.modifier()).executes(this::executeRemoveModifier)).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(this::executeRemoveModifier)))))));
    }

    private <T> T readArgumentOrDefault(CommandContext<CommandSourceStack> context, String name, BiFunction<CommandContext<CommandSourceStack>, String, T> getter, T defaultValue) {
        T result;
        try {
            result = getter.apply(context, name);
            if (result == null) {
                result = defaultValue;
            }
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
        return result;
    }

    private <T> T readArgumentOrDefault(CommandContext<CommandSourceStack> context, String name, Class<T> clazz, T defaultValue) {
        Object result;
        try {
            result = context.getArgument(name, clazz);
            if (result == null) {
                result = defaultValue;
            }
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
        return (T)result;
    }

    private int executeSetEntityTemp(CommandSourceStack source, Collection<? extends Entity> entities, double temp, Temperature.Trait trait) {
        if (entities.stream().anyMatch(entity -> !(entity instanceof Player) && !EntityTempManager.isTemperatureEnabled(entity))) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        for (Entity entity2 : entities) {
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity2;
            Temperature.set(living, trait == Temperature.Trait.BODY ? Temperature.Trait.CORE : trait, temp);
        }
        Temperature.Units preferredUnits = CSMath.getIfNotNull(source.m_230896_(), player -> Preference.getOrDefault((Player)player, Preference.UNITS, Temperature.Units.F), Temperature.Units.F);
        String string = trait.isForWorld() ? " " + preferredUnits.getFormattedName() : "";
        double convertedTemp = Temperature.convertIfNeeded(temp, trait, preferredUnits);
        if (entities.size() == 1) {
            Entity target = entities.iterator().next();
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.set.single.result", (Object[])new Object[]{trait.m_7912_(), target.m_7755_().getString(), CSMath.truncate(convertedTemp, 1) + string}), true);
        } else {
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.set.many.result", (Object[])new Object[]{trait.m_7912_(), entities.size(), CSMath.truncate(convertedTemp, 1) + string}), true);
        }
        return entities.size();
    }

    private int executeAddEntityTemp(CommandSourceStack source, Collection<? extends Entity> entities, double temp, Temperature.Trait trait) {
        if (entities.stream().anyMatch(entity -> !(entity instanceof Player) && !EntityTempManager.isTemperatureEnabled(entity))) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        for (Entity entity2 : entities) {
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity2;
            Temperature.add(living, trait == Temperature.Trait.BODY ? Temperature.Trait.CORE : trait, temp);
        }
        Temperature.Units preferredUnits = CSMath.getIfNotNull(source.m_230896_(), player -> Preference.getOrDefault((Player)player, Preference.UNITS, Temperature.Units.F), Temperature.Units.F);
        String string = trait.isForWorld() ? " " + preferredUnits.getFormattedName() : "";
        double convertedTemp = Temperature.convertIfNeeded(temp, trait, preferredUnits);
        if (entities.size() == 1) {
            Entity target = entities.iterator().next();
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.set.single.result", (Object[])new Object[]{trait.m_7912_(), target.m_7755_().getString(), CSMath.truncate(convertedTemp, 1) + string}), true);
        } else {
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.set.many.result", (Object[])new Object[]{trait.m_7912_(), entities.size(), CSMath.truncate(convertedTemp, 1) + string}), true);
        }
        return entities.size();
    }

    private int executeGetEntityTemp(CommandSourceStack source, Collection<? extends Entity> entities, Temperature.Trait trait) {
        if (entities.stream().anyMatch(entity -> !(entity instanceof Player) && !EntityTempManager.isTemperatureEnabled(entity))) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        for (Entity target : entities.stream().sorted(Comparator.comparing(player -> player.m_7755_().getString())).toList()) {
            Temperature.Units preferredUnits = CSMath.getIfNotNull(source.m_230896_(), player -> Preference.getOrDefault((Player)player, Preference.UNITS, Temperature.Units.F), Temperature.Units.F);
            double temp = CSMath.truncate(Temperature.convertIfNeeded(Temperature.get((LivingEntity)target, trait), trait, preferredUnits), 2);
            String unitsName = trait.isForWorld() ? " " + preferredUnits.getFormattedName() : "";
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.get.result", (Object[])new Object[]{target.m_7755_().getString(), trait.m_7912_(), temp + unitsName}), false);
        }
        return entities.size();
    }

    private int executeGetWorldTemp(CommandSourceStack source, int x, int y, int z, ServerLevel level) {
        Temperature.Units units = CSMath.getIfNotNull(source.m_230896_(), player -> Preference.getOrDefault((Player)player, Preference.UNITS, Temperature.Units.F), Temperature.Units.F);
        int worldTemp = (int)Temperature.convert(WorldHelper.getTemperatureAt((Level)(level != null ? level : source.m_81372_()), new BlockPos(x, y, z)), Temperature.Units.MC, units, true);
        source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.get.world.result", (Object[])new Object[]{x, y, z, worldTemp, units.getFormattedName()}), true);
        return 1;
    }

    private int executeAddModifier(CommandContext<CommandSourceStack> context) {
        Collection entities = this.readArgumentOrDefault(context, "entities", (CommandContext<CommandSourceStack> src, String str) -> {
            try {
                return EntityArgument.m_91461_((CommandContext)src, (String)str);
            }
            catch (Exception ignored) {
                return List.of();
            }
        }, List.of());
        Temperature.Trait trait = this.readArgumentOrDefault(context, "trait", TempModifierTraitArgument::getModifier, Temperature.Trait.BODY);
        ResourceLocation modifierId = this.readArgumentOrDefault(context, "modifier", TempModifierArgument::getModifier, null);
        int duration = this.readArgumentOrDefault(context, "duration", IntegerArgumentType::getInteger, Integer.valueOf(-1));
        int tickRate = this.readArgumentOrDefault(context, "tickRate", IntegerArgumentType::getInteger, Integer.valueOf(1));
        CompoundTag nbt = this.readArgumentOrDefault(context, "nbt", NbtTagArgument::m_100662_, new CompoundTag());
        Placement.Mode mode = this.readArgumentOrDefault(context, "mode", Placement.Mode.class, Placement.Mode.AFTER);
        Placement.Order order = this.readArgumentOrDefault(context, "order", Placement.Order.class, Placement.Order.LAST);
        ResourceLocation otherId = this.readArgumentOrDefault(context, "match", ResourceLocation.class, null);
        int maxCount = this.readArgumentOrDefault(context, "maxCount", IntegerArgumentType::getInteger, Integer.valueOf(1));
        return this.executeAddModifier(context, entities, trait, modifierId, duration, tickRate, nbt, mode, order, otherId, maxCount);
    }

    private int executeAddModifier(CommandContext<CommandSourceStack> context, Collection<? extends Entity> entities, Temperature.Trait trait, ResourceLocation modifierId, int duration, int tickRate, CompoundTag nbt, Placement.Mode mode, Placement.Order order, ResourceLocation otherId, int maxCount) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (entities.stream().anyMatch(entity -> !(entity instanceof Player) && !EntityTempManager.isTemperatureEnabled(entity))) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        Optional<TempModifier> modifierOpt = TempModifierRegistry.getValue(modifierId);
        if (modifierOpt.isEmpty()) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.cold_sweat.temp_modifier.invalid"));
            return 0;
        }
        TempModifier modifier = modifierOpt.get();
        ((TempModifier)modifier.expires(duration)).tickRate(tickRate);
        modifier.getNBT().m_128391_(nbt);
        for (Entity entity2 : entities) {
            Temperature.addModifier((LivingEntity)entity2, modifier, trait, Placement.Duplicates.ALLOW, maxCount, Placement.of(mode, order, mod -> otherId == null || TempModifierRegistry.getKey(mod).equals((Object)otherId)));
        }
        if (entities.size() == 1) {
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temp_modifier.single.add.result", (Object[])new Object[]{modifierId, entities.iterator().next().m_7755_().getString()}), true);
        } else {
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temp_modifier.many.add.result", (Object[])new Object[]{modifierId, entities.size()}), true);
        }
        return entities.size();
    }

    private int executeRemoveModifier(CommandContext<CommandSourceStack> context) {
        Collection entities = this.readArgumentOrDefault(context, "entities", (CommandContext<CommandSourceStack> src, String str) -> {
            try {
                return EntityArgument.m_91461_((CommandContext)src, (String)str);
            }
            catch (Exception ignored) {
                return List.of();
            }
        }, List.of());
        Temperature.Trait trait = this.readArgumentOrDefault(context, "trait", TempModifierTraitArgument::getModifier, Temperature.Trait.BODY);
        ResourceLocation modifierId = this.readArgumentOrDefault(context, "modifier", TempModifierArgument::getModifier, null);
        int count = this.readArgumentOrDefault(context, "count", IntegerArgumentType::getInteger, Integer.valueOf(Integer.MAX_VALUE));
        return this.executeRemoveModifier(context, entities, trait, modifierId, count);
    }

    private int executeRemoveModifier(CommandContext<CommandSourceStack> context, Collection<? extends Entity> entities, Temperature.Trait trait, ResourceLocation modifierId, int count) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (entities.stream().anyMatch(entity -> !(entity instanceof Player) && !EntityTempManager.isTemperatureEnabled(entity))) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        if (TempModifierRegistry.getValue(modifierId).isEmpty()) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.cold_sweat.temp_modifier.invalid", (Object[])new Object[]{modifierId}));
            return 0;
        }
        for (Entity entity2 : entities) {
            Temperature.removeModifiers((LivingEntity)entity2, trait, count, Placement.Order.FIRST, mod -> TempModifierRegistry.getKey(mod).equals((Object)modifierId));
        }
        if (entities.size() == 1) {
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temp_modifier.single.remove.result", (Object[])new Object[]{modifierId, entities.iterator().next().m_7755_().getString()}), true);
        } else {
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temp_modifier.many.remove.result", (Object[])new Object[]{modifierId, entities.size()}), true);
        }
        return entities.size();
    }

    private int executeDebugModifiers(CommandSourceStack source, Entity entity, Temperature.Trait trait) {
        if (!(entity instanceof Player) && !EntityTempManager.isTemperatureEnabled(entity)) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        LivingEntity living = (LivingEntity)entity;
        AttributeInstance attribute = trait.isForAttributes() ? EntityTempManager.getAttribute(trait, living) : null;
        Temperature.Units preferredUnits = CSMath.getIfNotNull(source.m_230896_(), player -> Preference.getOrDefault((Player)player, Preference.UNITS, Temperature.Units.F), Temperature.Units.F);
        double lastValue = trait == Temperature.Trait.BURNING_POINT ? ConfigSettings.MAX_TEMP.get() : (trait == Temperature.Trait.FREEZING_POINT ? ConfigSettings.MIN_TEMP.get() : 0.0);
        source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.debug", (Object[])new Object[]{living.m_5446_(), trait.m_7912_()}).m_130940_(ChatFormatting.WHITE), false);
        if (attribute != null && CSMath.safeDouble(attribute.m_22115_()).isPresent()) {
            source.m_81354_((Component)Component.m_237113_((String)ForgeRegistries.ATTRIBUTES.getKey((Object)attribute.m_22099_()).toString()).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)" \u2192 ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)("" + attribute.m_22135_())).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.AQUA).m_131144_(TempCommand.getConvertedUnitHover(trait, attribute.m_22135_(), preferredUnits)))), false);
            lastValue = attribute.m_22115_();
        } else {
            for (TempModifier modifier : Temperature.getModifiers(living, trait)) {
                double lastInput = modifier.getLastInput(trait);
                double lastOutput = modifier.getLastOutput(trait);
                source.m_81354_((Component)Component.m_237119_().m_7220_((Component)Component.m_237113_((String)("" + CSMath.truncate(lastInput, 2))).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE).m_131144_(TempCommand.getConvertedUnitHover(trait, lastInput, preferredUnits)))).m_7220_((Component)Component.m_237113_((String)" \u2192 ").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE).m_131144_(null))).m_7220_((Component)Component.m_237113_((String)modifier.toString()).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)" \u2192 ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)("" + CSMath.truncate(lastOutput, 2))).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.AQUA).m_131144_(TempCommand.getConvertedUnitHover(trait, lastOutput, preferredUnits)))), false);
                lastValue = lastOutput;
            }
        }
        if (attribute != null) {
            double newBase = lastValue;
            for (AttributeModifier modifier : attribute.m_22104_(AttributeModifier.Operation.ADDITION)) {
                TempCommand.printAttributeModifierLine(source, modifier, lastValue, newBase += modifier.m_22218_(), trait, preferredUnits);
            }
            double newValue = newBase;
            for (AttributeModifier modifier : attribute.m_22104_(AttributeModifier.Operation.MULTIPLY_BASE)) {
                TempCommand.printAttributeModifierLine(source, modifier, lastValue, newValue += newBase * modifier.m_22218_(), trait, preferredUnits);
            }
            for (AttributeModifier modifier : attribute.m_22104_(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
                TempCommand.printAttributeModifierLine(source, modifier, lastValue, newValue *= 1.0 + modifier.m_22218_(), trait, preferredUnits);
            }
        }
        return 1;
    }

    static void printAttributeModifierLine(CommandSourceStack source, AttributeModifier modifier, double lastValueStore, double newValueStore, Temperature.Trait trait, Temperature.Units preferredUnits) {
        source.m_81354_((Component)Component.m_237113_((String)("" + CSMath.truncate(lastValueStore, 2))).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE).m_131144_(TempCommand.getConvertedUnitHover(trait, lastValueStore, preferredUnits))).m_7220_((Component)Component.m_237113_((String)" \u2192 ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)modifier.m_22214_()).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.LIGHT_PURPLE).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)modifier.m_22209_().toString()).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"chat.copy.click").m_130940_(ChatFormatting.GRAY)))).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, modifier.m_22209_().toString())))).m_7220_((Component)Component.m_237113_((String)" \u2192 ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)("" + CSMath.truncate(newValueStore, 2))).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.AQUA).m_131144_(TempCommand.getConvertedUnitHover(trait, newValueStore, preferredUnits)))), false);
    }

    static double getFormattedTraitValue(Temperature.Trait trait, double rawValue, Temperature.Units units) {
        double converted;
        block3: {
            converted = rawValue;
            switch (trait) {
                case WORLD: 
                case FREEZING_POINT: 
                case BURNING_POINT: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            converted = Temperature.convert(converted, Temperature.Units.MC, units, true);
        }
        return converted;
    }

    static HoverEvent getConvertedUnitHover(Temperature.Trait trait, double value, Temperature.Units units) {
        return new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)(CSMath.truncate(TempCommand.getFormattedTraitValue(trait, value, units), 1) + " " + units.getFormattedName())));
    }

    private int executeModifyEntityTemp(CommandSourceStack source, Collection<? extends Entity> entities, Temperature.Trait attribute, double amount, AttributeModifier.Operation operation, boolean permanent) {
        for (Entity entity : entities) {
            if (EntityTempManager.isTemperatureEnabled(entity) && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                AttributeInstance instance = EntityTempManager.getAttribute(attribute, living);
                if (instance == null) continue;
                if (operation != null) {
                    AttributeModifier modifier = EntityTempManager.makeAttributeModifier(attribute, amount, operation);
                    instance.m_22125_(modifier);
                } else {
                    EntityTempManager.getAttribute(attribute, living).m_22100_(amount);
                }
                EntityTempManager.getTemperatureCap(entity).ifPresent(cap -> {
                    if (permanent) {
                        cap.markPersistentAttribute(instance.m_22099_());
                    } else {
                        cap.clearPersistentAttribute(instance.m_22099_());
                    }
                });
                continue;
            }
            source.m_81352_((Component)Component.m_237115_((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        if (entities.size() == 1) {
            if (operation == null) {
                source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.modify.set.single.result", (Object[])new Object[]{attribute.m_7912_(), entities.iterator().next().m_7755_().getString(), amount}), true);
            } else {
                source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.modify.add_modifier.single.result", (Object[])new Object[]{attribute.m_7912_(), entities.iterator().next().m_7755_().getString()}), true);
            }
        } else if (operation == null) {
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.modify.set.many.result", (Object[])new Object[]{attribute.m_7912_(), entities.size(), amount}), true);
        } else {
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.modify.add_modifier.many.result", (Object[])new Object[]{attribute.m_7912_(), entities.size()}), true);
        }
        return entities.size();
    }

    private int executeClearModifier(CommandSourceStack source, Collection<? extends Entity> entities, Temperature.Trait attribute) {
        for (Entity entity : entities) {
            if (EntityTempManager.isTemperatureEnabled(entity) && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                EntityTempManager.getTemperatureCap(entity).ifPresent(cap -> {
                    AttributeInstance instance = EntityTempManager.getAttribute(attribute, living);
                    if (instance == null) {
                        return;
                    }
                    instance.m_22132_();
                    EntityTempManager.getAttribute(attribute, living).m_22100_(Double.NaN);
                    cap.clearPersistentAttribute(instance.m_22099_());
                });
                continue;
            }
            source.m_81352_((Component)Component.m_237115_((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        if (entities.size() == 1) {
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.clear.single.result", (Object[])new Object[]{attribute.m_7912_(), entities.iterator().next().m_7755_().getString()}), true);
        } else {
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.clear.many.result", (Object[])new Object[]{attribute.m_7912_(), entities.size()}), true);
        }
        return entities.size();
    }

    private int executeClearAllModifiers(CommandSourceStack source, Collection<? extends Entity> entities) {
        for (Entity entity : entities) {
            if (EntityTempManager.isTemperatureEnabled(entity) && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                EntityTempManager.getTemperatureCap(entity).ifPresent(cap -> {
                    for (Temperature.Trait attribute : EntityTempManager.VALID_ATTRIBUTE_TRAITS) {
                        AttributeInstance instance = EntityTempManager.getAttribute(attribute, living);
                        if (instance == null) continue;
                        instance.m_22132_();
                        instance.m_22100_(instance.m_22099_().m_22082_());
                        cap.clearPersistentAttribute(instance.m_22099_());
                    }
                });
                continue;
            }
            source.m_81352_((Component)Component.m_237115_((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        if (entities.size() == 1) {
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.clear.all.single.result", (Object[])new Object[]{entities.iterator().next().m_7755_().getString()}), true);
        } else {
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.clear.all.many.result", (Object[])new Object[]{entities.size()}), true);
        }
        return entities.size();
    }
}

