/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.DisableHearthParticlesMessage;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class HearthSaveDataHandler {
    public static final Set<Pair<BlockPos, ResourceLocation>> HEARTH_POSITIONS = new HashSet<Pair<BlockPos, ResourceLocation>>();
    public static final Set<Pair<BlockPos, ResourceLocation>> DISABLED_HEARTHS = new HashSet<Pair<BlockPos, ResourceLocation>>();

    @SubscribeEvent
    public static void saveDisabledHearths(PlayerEvent.PlayerLoggedOutEvent event) {
        event.getEntity().getPersistentData().m_128365_("disabledHearths", (Tag)HearthSaveDataHandler.serializeDisabledHearths());
    }

    public static CompoundTag serializeDisabledHearths() {
        CompoundTag tag = new CompoundTag();
        ListTag disabledHearths = new ListTag();
        for (Pair<BlockPos, ResourceLocation> pair : DISABLED_HEARTHS) {
            CompoundTag hearthData = new CompoundTag();
            hearthData.m_128356_("Pos", ((BlockPos)pair.getFirst()).m_121878_());
            hearthData.m_128359_("Level", ((ResourceLocation)pair.getSecond()).toString());
            disabledHearths.add((Object)hearthData);
        }
        tag.m_128365_("DisabledHearths", (Tag)disabledHearths);
        return tag;
    }

    public static void deserializeDisabledHearths(CompoundTag disabledHearths) {
        DISABLED_HEARTHS.clear();
        for (Tag tag : disabledHearths.m_128437_("DisabledHearths", 10)) {
            CompoundTag hearthData = (CompoundTag)tag;
            DISABLED_HEARTHS.add((Pair<BlockPos, ResourceLocation>)Pair.of((Object)BlockPos.m_122022_((long)hearthData.m_128454_("Pos")), (Object)new ResourceLocation(hearthData.m_128461_("Level"))));
        }
    }

    @SubscribeEvent
    public static void loadDisabledHearths(PlayerEvent.PlayerLoggedInEvent event) {
        Player player;
        if (!event.getEntity().f_19853_.f_46443_ && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            CompoundTag disabledHearths = new CompoundTag();
            disabledHearths.m_128365_("DisabledHearths", (Tag)player2.getPersistentData().m_128437_("DisabledHearths", 10));
            ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new DisableHearthParticlesMessage(disabledHearths));
        }
    }

    @SubscribeEvent
    public static void transferDisabledHearths(PlayerEvent.Clone event) {
        if (!event.getEntity().f_19853_.m_5776_()) {
            ListTag disabledHearths = event.getOriginal().getPersistentData().m_128437_("DisabledHearths", 10);
            event.getEntity().getPersistentData().m_128365_("DisabledHearths", (Tag)disabledHearths);
        }
    }
}

