/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.item;

import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.itemgroup.ColdSweatGroup;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.registries.ModSounds;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class WaterskinItem
extends Item {
    public static final int FLUID_VALUE_MB = 250;

    public WaterskinItem() {
        super(new Item.Properties().m_41491_((CreativeModeTab)ColdSweatGroup.COLD_SWEAT).m_41487_(16));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(pos);
        Player player = context.m_43723_();
        if (player == null) {
            WorldHelper.dropItem(level, pos, WaterskinItem.getFilledItem(context.m_43722_(), level, pos));
            return super.m_6225_(context);
        }
        if (player.m_150110_().f_35938_ && state.m_60734_() == Blocks.f_152476_ && (Integer)state.m_61143_((Property)BlockStateProperties.f_61418_) > 0) {
            if (!player.m_7500_()) {
                LayeredCauldronBlock.m_153559_((BlockState)state, (Level)level, (BlockPos)pos);
            }
            WaterskinItem.handleFillWaterskin(player, context.m_43722_(), context.m_43724_(), pos);
            WorldHelper.spawnParticleBatch(level, (ParticleOptions)ParticleTypes.f_123769_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.65, (double)pos.m_123343_() + 0.5, 0.5, 0.5, 0.5, 10.0, 0.0);
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity != null) {
            blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, context.m_43719_()).ifPresent(cap -> {
                for (int i = 0; i < cap.getTanks(); ++i) {
                    FluidStack fluidStack = cap.getFluidInTank(i);
                    if (!fluidStack.getFluid().m_205067_(FluidTags.f_13131_) || fluidStack.getAmount() < 250) continue;
                    FluidStack drainStack = fluidStack.copy();
                    drainStack.setAmount(250);
                    cap.drain(drainStack, IFluidHandler.FluidAction.EXECUTE);
                    WaterskinItem.handleFillWaterskin(player, context.m_43722_(), context.m_43724_(), pos);
                    return;
                }
            });
        }
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        InteractionResultHolder ar = super.m_7203_(level, player, hand);
        ItemStack itemstack = (ItemStack)ar.m_19095_();
        BlockHitResult blockhitresult = WaterskinItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        BlockPos hitPos = blockhitresult.m_82425_();
        BlockState lookingAt = level.m_8055_(hitPos);
        if (blockhitresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (lookingAt.m_60819_().m_76170_() && lookingAt.m_60819_().m_76152_().m_6212_((Fluid)Fluids.f_76193_)) {
            WaterskinItem.handleFillWaterskin(player, itemstack, hand, hitPos);
            WorldHelper.spawnParticleBatch(level, (ParticleOptions)ParticleTypes.f_123769_, (double)hitPos.m_123341_() + 0.5, hitPos.m_123342_() + 1, (double)hitPos.m_123343_() + 0.5, 0.5, 0.5, 0.5, 10.0, 0.0);
        }
        return ar;
    }

    public static ItemStack getFilledItem(ItemStack stack, Level level, BlockPos pos) {
        ItemStack filledWaterskin = ModItems.FILLED_WATERSKIN.m_7968_();
        filledWaterskin.m_41751_(stack.m_41783_());
        filledWaterskin.m_41784_().m_128347_("Temperature", CSMath.clamp((WorldHelper.getTemperatureAt(level, pos) - CSMath.average(ConfigSettings.MAX_TEMP.get(), ConfigSettings.MIN_TEMP.get())) * 15.0, -50.0, 50.0));
        if (CompatManager.isThirstLoaded()) {
            filledWaterskin = CompatManager.Thirst.setPurityFromBlock(filledWaterskin, pos, level);
        }
        return filledWaterskin;
    }

    public static void handleFillWaterskin(Player player, ItemStack thisStack, InteractionHand usedHand, BlockPos filledAtPos) {
        Level level = player.f_19853_;
        ItemStack filledWaterskin = WaterskinItem.getFilledItem(thisStack, level, filledAtPos);
        if (thisStack.m_41613_() > 1 || player.m_150110_().f_35937_) {
            ItemEntity itementity;
            if (!player.m_36356_(filledWaterskin) && (itementity = player.m_36176_(filledWaterskin, false)) != null) {
                itementity.m_32061_();
                itementity.m_32052_(player.m_20148_());
            }
            thisStack.m_41774_(1);
        } else {
            player.m_21008_(usedHand, filledWaterskin);
        }
        player.m_6674_(usedHand);
        player.m_36335_().m_41524_(ModItems.FILLED_WATERSKIN, 10);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)thisStack.m_41720_()));
        level.m_5594_(null, filledAtPos, ModSounds.WATERSKIN_FILL, SoundSource.PLAYERS, 2.0f, (float)Math.random() / 5.0f + 0.9f);
    }

    public boolean m_6777_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }
}

