/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.compat.jei.JeiPlugin;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.elements.DrawableResource;
import mezz.jei.library.gui.ingredients.RecipeSlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.ItemStack;

public abstract class ColdSweatFuelCategory
implements IRecipeCategory<JeiPlugin.FuelRecipe> {
    private final IDrawable icon;
    private final IDrawableStatic background;

    public ColdSweatFuelCategory(IGuiHelper guiHelper, ItemStack icon) {
        int width = this.getMaxWidth();
        int height = 34;
        this.icon = guiHelper.createDrawableItemStack(icon);
        this.background = guiHelper.createBlankDrawable(width, height);
    }

    public abstract RecipeType<JeiPlugin.FuelRecipe> getRecipeType();

    public abstract Component getTitle();

    protected abstract HearthBlockEntity getDummyBlockEntity();

    protected abstract ResourceLocation getEmptyGaugeTexture(JeiPlugin.FuelRecipe var1);

    protected abstract ResourceLocation getFilledGaugeTexture(JeiPlugin.FuelRecipe var1);

    public IDrawable getIcon() {
        return this.icon;
    }

    protected int getMaxWidth() {
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        HearthBlockEntity dummyBlockEntity = this.getDummyBlockEntity();
        Component maxSmeltCountText = ColdSweatFuelCategory.createFillAmountText(dummyBlockEntity.getMaxFuel(), dummyBlockEntity);
        int maxStringWidth = fontRenderer.m_92895_(maxSmeltCountText.getString());
        int textPadding = 20;
        return 18 + textPadding + maxStringWidth;
    }

    public IDrawableStatic getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, JeiPlugin.FuelRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 17).setBackground((IDrawable)Internal.getTextures().getSlotDrawable(), -1, -1).addItemStacks(List.of(recipe.input()));
    }

    public void draw(JeiPlugin.FuelRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        HearthBlockEntity dummyBlockEntity = this.getDummyBlockEntity();
        double fuel = Math.abs(recipe.fuelData().fuel());
        Component fillAmountText = ColdSweatFuelCategory.createFillAmountText(fuel, dummyBlockEntity);
        int textWidth = font.m_92895_(fillAmountText.getString());
        int textX = this.getWidth() - 12 - textWidth;
        int textY = this.getHeight() - 20;
        font.m_92889_(poseStack, fillAmountText, (float)textX, (float)textY, -8355712);
        int gaugeHeight = fuel <= 0.0 ? 0 : (int)Math.round(CSMath.blend(2.0, 14.0, fuel, 0.0, (double)dummyBlockEntity.getMaxFuel()));
        int maxGaugeHeight = 14;
        DrawableResource fuelGauge = new DrawableResource(this.getFilledGaugeTexture(recipe), 0, 14 - gaugeHeight, 14, gaugeHeight, 0, 0, 0, 0, 14, 14);
        DrawableResource emptyFuelGauge = new DrawableResource(this.getEmptyGaugeTexture(recipe), 0, 0, 14, 14, 0, 0, 0, 0, 14, 14);
        emptyFuelGauge.draw(poseStack, 2, 0);
        fuelGauge.draw(poseStack, 2, 0 + (maxGaugeHeight - gaugeHeight));
        for (IRecipeSlotView slot : recipeSlotsView.getSlotViews()) {
            if (!(slot instanceof RecipeSlot)) continue;
            RecipeSlot recipeSlot = (RecipeSlot)slot;
            recipeSlot.draw(poseStack);
        }
    }

    private static Component createFillAmountText(double fuelAmount, HearthBlockEntity dummyBlockEntity) {
        int fuelInterval = dummyBlockEntity.getFuelDrainInterval();
        int durationTicks = (int)Math.round(fuelAmount * (double)fuelInterval);
        return Component.m_237110_((String)"jei.cold_sweat.fuel_duration", (Object[])new Object[]{StringUtil.m_14404_((int)durationTicks)});
    }
}

