/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.data.ModRegistries;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.requirement.BlockRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.LocationRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.WorldTempRequirement;
import com.momosoftworks.coldsweat.data.codec.util.ExtraCodecs;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockTempData
extends ConfigData {
    final NegatableList<BlockRequirement> block;
    final double temperature;
    final double range;
    final double maxEffect;
    final boolean fade;
    final WorldTempRequirement maxTemp;
    final WorldTempRequirement minTemp;
    final Temperature.Units units;
    final NegatableList<LocationRequirement> location;
    final NegatableList<EntityRequirement> entity;
    final boolean logarithmic;
    final Optional<TagKey<BlockTempData>> effectGroup;
    public static final Codec<BlockTempData> CODEC = BlockTempData.createCodec(RecordCodecBuilder.mapCodec(instance -> instance.group((App)NegatableList.codec(BlockRequirement.CODEC).fieldOf("block").forGetter(BlockTempData::block), (App)Codec.DOUBLE.fieldOf("temperature").forGetter(BlockTempData::temperature), (App)Codec.DOUBLE.optionalFieldOf("range", (Object)Double.POSITIVE_INFINITY).forGetter(BlockTempData::range), (App)Codec.DOUBLE.optionalFieldOf("max_effect", (Object)Double.POSITIVE_INFINITY).forGetter(BlockTempData::maxEffect), (App)Codec.BOOL.optionalFieldOf("fade", (Object)true).forGetter(BlockTempData::fade), (App)WorldTempRequirement.CODEC.optionalFieldOf("max_temp", (Object)WorldTempRequirement.INFINITY).forGetter(BlockTempData::maxTemp), (App)WorldTempRequirement.CODEC.optionalFieldOf("min_temp", (Object)WorldTempRequirement.NEGATIVE_INFINITY).forGetter(BlockTempData::minTemp), (App)Temperature.Units.CODEC.optionalFieldOf("units", (Object)Temperature.Units.MC).forGetter(BlockTempData::units), (App)NegatableList.codec(LocationRequirement.CODEC).optionalFieldOf("location", new NegatableList()).forGetter(BlockTempData::location), (App)NegatableList.codec(EntityRequirement.getCodec()).optionalFieldOf("entity", new NegatableList()).forGetter(BlockTempData::entity), (App)Codec.BOOL.optionalFieldOf("logarithmic", (Object)false).forGetter(BlockTempData::logarithmic), (App)ExtraCodecs.deferred(() -> TagKey.m_203877_(ModRegistries.BLOCK_TEMP_DATA.key())).optionalFieldOf("effect_group").forGetter(BlockTempData::effectGroup)).apply((Applicative)instance, BlockTempData::new)));

    public BlockTempData(NegatableList<BlockRequirement> block, double temperature, double range, double maxEffect, boolean fade, WorldTempRequirement maxTemp, WorldTempRequirement minTemp, Temperature.Units units, NegatableList<LocationRequirement> location, NegatableList<EntityRequirement> entity, boolean logarithmic, Optional<TagKey<BlockTempData>> effectGroup, NegatableList<String> requiredMods) {
        super(requiredMods);
        this.block = block;
        this.temperature = temperature;
        this.range = range;
        this.maxEffect = maxEffect;
        this.fade = fade;
        this.maxTemp = maxTemp;
        this.minTemp = minTemp;
        this.units = units;
        this.location = location;
        this.entity = entity;
        this.logarithmic = logarithmic;
        this.effectGroup = effectGroup;
    }

    public BlockTempData(NegatableList<BlockRequirement> block, double temperature, double range, double maxEffect, boolean fade, WorldTempRequirement maxTemp, WorldTempRequirement minTemp, Temperature.Units units, NegatableList<LocationRequirement> location, NegatableList<EntityRequirement> entity, boolean logarithmic, Optional<TagKey<BlockTempData>> effectGroup) {
        this(block, temperature, range, maxEffect, fade, maxTemp, minTemp, units, location, entity, logarithmic, effectGroup, new NegatableList<String>());
    }

    public BlockTempData(BlockTemp blockTemp) {
        this(new NegatableList<BlockRequirement>(new BlockRequirement(blockTemp.getAffectedBlocks().stream().map(Either::right).toList())), 0.0, blockTemp.range(), blockTemp.maxEffect(), true, new WorldTempRequirement(blockTemp.maxTemperature()), new WorldTempRequirement(blockTemp.minTemperature()), Temperature.Units.MC, new NegatableList<LocationRequirement>(), new NegatableList<EntityRequirement>(), blockTemp.logarithmic(), Optional.empty());
    }

    public NegatableList<BlockRequirement> block() {
        return this.block;
    }

    public double temperature() {
        return this.temperature;
    }

    public double range() {
        return this.range;
    }

    public double maxEffect() {
        return this.maxEffect;
    }

    public boolean fade() {
        return this.fade;
    }

    public WorldTempRequirement maxTemp() {
        return this.maxTemp;
    }

    public WorldTempRequirement minTemp() {
        return this.minTemp;
    }

    public Temperature.Units units() {
        return this.units;
    }

    public NegatableList<LocationRequirement> location() {
        return this.location;
    }

    public NegatableList<EntityRequirement> entity() {
        return this.entity;
    }

    public boolean logarithmic() {
        return this.logarithmic;
    }

    public Optional<TagKey<BlockTempData>> effectGroup() {
        return this.effectGroup;
    }

    public double getTemperature() {
        return Temperature.convert(this.temperature, this.units, Temperature.Units.MC, false);
    }

    public double getMaxEffect() {
        return Temperature.convert(this.maxEffect, this.units, Temperature.Units.MC, false);
    }

    public double getMaxTemp() {
        return this.maxTemp.get(this.units);
    }

    public double getMinTemp() {
        return this.minTemp.get(this.units);
    }

    @Nullable
    public static BlockTempData fromToml(List<?> entry) {
        String str;
        Object obj;
        String str2;
        Object obj2;
        if (entry.size() < 3) {
            ColdSweat.LOGGER.error("Error parsing block config: not enough arguments");
            return null;
        }
        NegatableList<Either<TagKey<Block>, Block>> blocks = ConfigHelper.getBlocks((String)entry.get(0));
        if (blocks.isEmpty()) {
            return null;
        }
        Block[] effectBlocks = RegistryHelper.mapForgeRegistryTagList(ForgeRegistries.BLOCKS, blocks).toArray(new Block[0]);
        double blockTemp = ((Number)entry.get(1)).doubleValue();
        double blockRange = ((Number)entry.get(2)).doubleValue();
        Temperature.Units units = entry.size() > 3 && entry.get(3) instanceof String ? Temperature.Units.fromID((String)entry.get(3)) : Temperature.Units.MC;
        double maxEffect = entry.size() > 4 && entry.get(4) instanceof Number ? ((Number)entry.get(4)).doubleValue() : Double.POSITIVE_INFINITY;
        BlockRequirement.StateRequirement blockPredicates = entry.size() > 5 && (obj2 = entry.get(5)) instanceof String && !(str2 = (String)obj2).isBlank() ? BlockRequirement.StateRequirement.fromToml(str2.split(","), effectBlocks[0]) : BlockRequirement.StateRequirement.NONE;
        NbtRequirement nbtRequirement = entry.size() > 6 && (obj = entry.get(6)) instanceof String && !(str = (String)obj).isBlank() ? new NbtRequirement(NBTHelper.parseCompoundNbt(str)) : NbtRequirement.NONE;
        double tempLimit = entry.size() > 7 ? ((Number)entry.get(7)).doubleValue() : Double.POSITIVE_INFINITY;
        boolean logarithmic = entry.size() > 8 && entry.get(8) instanceof Boolean ? (Boolean)entry.get(8) : false;
        double maxTemperature = blockTemp > 0.0 ? tempLimit : Double.POSITIVE_INFINITY;
        double minTemperature = blockTemp < 0.0 ? tempLimit : Double.NEGATIVE_INFINITY;
        BlockRequirement blockRequirement = new BlockRequirement(blocks, blockPredicates, nbtRequirement, List.of(), Optional.empty());
        BlockTempData result = new BlockTempData(new NegatableList<BlockRequirement>(blockRequirement), blockTemp, blockRange, maxEffect, true, new WorldTempRequirement(maxTemperature), new WorldTempRequirement(minTemperature), units, new NegatableList<LocationRequirement>(), new NegatableList<EntityRequirement>(), logarithmic, Optional.empty());
        result.setConfigType(ConfigData.Type.TOML);
        return result;
    }

    public Codec<BlockTempData> getCodec() {
        return CODEC;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlockTempData that = (BlockTempData)obj;
        return super.equals(obj) && Double.compare(that.temperature, this.temperature) == 0 && Double.compare(that.range, this.range) == 0 && Double.compare(that.maxEffect, this.maxEffect) == 0 && this.maxTemp.equals(that.maxTemp) && this.minTemp.equals(that.minTemp) && this.fade == that.fade && this.block.equals(that.block);
    }
}

