/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.registries.ForgeRegistries;

public record EffectsRequirement(Map<MobEffect, Instance> effects) {
    public static final Codec<EffectsRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap(ConfigHelper.tagOrBuiltinCodec(Registry.f_122900_, ForgeRegistries.MOB_EFFECTS), Instance.CODEC).xmap(map -> {
        HashMap effects = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            ((Either)entry.getKey()).map(tag -> {
                ForgeRegistries.MOB_EFFECTS.tags().getTag(tag).stream().forEach(effect -> effects.put(effect, (Instance)entry.getValue()));
                return null;
            }, effect -> effects.put(effect, (Instance)entry.getValue()));
        }
        return effects;
    }, effects -> {
        HashMap<Either, Instance> map = new HashMap<Either, Instance>();
        for (Map.Entry entry : effects.entrySet()) {
            map.put(Either.right((Object)((MobEffect)entry.getKey())), (Instance)entry.getValue());
        }
        return map;
    }).fieldOf("effects").forGetter(predicate -> predicate.effects)).apply((Applicative)instance, EffectsRequirement::new));

    public boolean test(Entity entity) {
        LivingEntity living;
        return !(entity instanceof LivingEntity) || this.test((living = (LivingEntity)entity).m_21220_());
    }

    public boolean test(Collection<MobEffectInstance> effects) {
        for (Map.Entry<MobEffect, Instance> entry : this.effects.entrySet()) {
            MobEffect effect = entry.getKey();
            Instance instance = entry.getValue();
            int amplifier = 0;
            int duration = 0;
            boolean ambient = true;
            boolean visible = true;
            for (MobEffectInstance effectInstance : effects) {
                if (effectInstance.m_19544_() != effect) continue;
                amplifier = effectInstance.m_19564_();
                duration = effectInstance.m_19557_();
                ambient = effectInstance.m_19571_();
                visible = effectInstance.m_19572_();
                break;
            }
            if (!instance.amplifier().test(amplifier) || !instance.duration().test(duration)) {
                return false;
            }
            if (instance.ambient().isPresent() && instance.ambient().get() != ambient) {
                return false;
            }
            if (!instance.visible().isPresent() || instance.visible().get() == visible) continue;
            return false;
        }
        return true;
    }

    public boolean test(MobEffectInstance effect) {
        Instance instance = this.effects.get(effect.m_19544_());
        if (instance == null) {
            return true;
        }
        return !(!instance.amplifier().test(effect.m_19564_()) || !instance.duration().test(effect.m_19557_()) || !instance.ambient().isEmpty() && instance.ambient().get().booleanValue() != effect.m_19571_() || !instance.visible().isEmpty() && instance.visible().get().booleanValue() != effect.m_19572_());
    }

    @Override
    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EffectsRequirement that = (EffectsRequirement)obj;
        return this.effects.equals(that.effects);
    }

    public record Instance(IntegerBounds amplifier, IntegerBounds duration, Optional<Boolean> ambient, Optional<Boolean> visible) {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntegerBounds.CODEC.fieldOf("amplifier").forGetter(effect -> effect.amplifier), (App)IntegerBounds.CODEC.fieldOf("duration").forGetter(effect -> effect.duration), (App)Codec.BOOL.optionalFieldOf("ambient").forGetter(effect -> effect.ambient), (App)Codec.BOOL.optionalFieldOf("visible").forGetter(effect -> effect.visible)).apply((Applicative)instance, Instance::new));

        @Override
        public String toString() {
            return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Instance that = (Instance)obj;
            return this.amplifier.equals(that.amplifier) && this.duration.equals(that.duration) && this.ambient.equals(that.ambient) && this.visible.equals(that.visible);
        }
    }
}

