/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin.compat;

import com.momosoftworks.coldsweat.config.ConfigSettings;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.TickEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sereneseasons.api.season.Season;
import sereneseasons.handler.season.RandomUpdateHandler;

@Mixin(value={RandomUpdateHandler.class})
public class MixinSereneIceMelt {
    @Inject(method={"meltInChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/IceBlock;melt(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V")}, cancellable=true, remap=false)
    private static void getBiomeTemperatureOverride(ChunkMap chunkManager, LevelChunk chunkIn, Season.SubSeason subSeason, CallbackInfo ci) {
        if (ConfigSettings.USE_CUSTOM_WATER_FREEZE_BEHAVIOR.get().booleanValue()) {
            ci.cancel();
        }
    }

    @ModifyVariable(method={"onWorldTick"}, at=@At(value="STORE", ordinal=0), remap=false)
    private static int tickSpeedMeltRolls(int rolls, TickEvent.LevelTickEvent event) {
        if (!ConfigSettings.USE_CUSTOM_WATER_FREEZE_BEHAVIOR.get().booleanValue()) {
            return rolls;
        }
        Level level = event.level;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            int tickSpeed = level2.m_46469_().m_46215_(GameRules.f_46143_);
            return rolls * tickSpeed / 3;
        }
        return rolls;
    }
}

